package zio.aws.acmpca.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.{String3To255, String253, Integer1To5000}
import scala.jdk.CollectionConverters._
final case class CrlConfiguration(
    enabled: Boolean,
    expirationInDays: Option[Integer1To5000] = None,
    customCname: Option[String253] = None,
    s3BucketName: Option[String3To255] = None,
    s3ObjectAcl: Option[zio.aws.acmpca.model.S3ObjectAcl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CrlConfiguration = {
    import CrlConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CrlConfiguration
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        expirationInDays.map(value => Integer1To5000.unwrap(value): Integer)
      )(_.expirationInDays)
      .optionallyWith(
        customCname.map(value => String253.unwrap(value): java.lang.String)
      )(_.customCname)
      .optionallyWith(
        s3BucketName.map(value => String3To255.unwrap(value): java.lang.String)
      )(_.s3BucketName)
      .optionallyWith(s3ObjectAcl.map(value => value.unwrap))(_.s3ObjectAcl)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.CrlConfiguration.ReadOnly =
    zio.aws.acmpca.model.CrlConfiguration.wrap(buildAwsValue())
}
object CrlConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CrlConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CrlConfiguration =
      zio.aws.acmpca.model.CrlConfiguration(
        enabled,
        expirationInDays.map(value => value),
        customCname.map(value => value),
        s3BucketName.map(value => value),
        s3ObjectAcl.map(value => value)
      )
    def enabled: Boolean
    def expirationInDays: Option[Integer1To5000]
    def customCname: Option[String253]
    def s3BucketName: Option[String3To255]
    def s3ObjectAcl: Option[zio.aws.acmpca.model.S3ObjectAcl]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getExpirationInDays: ZIO[Any, AwsError, Integer1To5000] =
      AwsError.unwrapOptionField("expirationInDays", expirationInDays)
    def getCustomCname: ZIO[Any, AwsError, String253] =
      AwsError.unwrapOptionField("customCname", customCname)
    def getS3BucketName: ZIO[Any, AwsError, String3To255] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3ObjectAcl: ZIO[Any, AwsError, zio.aws.acmpca.model.S3ObjectAcl] =
      AwsError.unwrapOptionField("s3ObjectAcl", s3ObjectAcl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CrlConfiguration
  ) extends zio.aws.acmpca.model.CrlConfiguration.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val expirationInDays: Option[Integer1To5000] = scala
      .Option(impl.expirationInDays())
      .map(value => zio.aws.acmpca.model.primitives.Integer1To5000(value))
    override val customCname: Option[String253] = scala
      .Option(impl.customCname())
      .map(value => zio.aws.acmpca.model.primitives.String253(value))
    override val s3BucketName: Option[String3To255] = scala
      .Option(impl.s3BucketName())
      .map(value => zio.aws.acmpca.model.primitives.String3To255(value))
    override val s3ObjectAcl: Option[zio.aws.acmpca.model.S3ObjectAcl] = scala
      .Option(impl.s3ObjectAcl())
      .map(value => zio.aws.acmpca.model.S3ObjectAcl.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CrlConfiguration
  ): zio.aws.acmpca.model.CrlConfiguration.ReadOnly = new Wrapper(impl)
}
