package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CsrExtensions(
    keyUsage: Option[zio.aws.acmpca.model.KeyUsage] = None,
    subjectInformationAccess: Option[
      Iterable[zio.aws.acmpca.model.AccessDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CsrExtensions = {
    import CsrExtensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CsrExtensions
      .builder()
      .optionallyWith(keyUsage.map(value => value.buildAwsValue()))(_.keyUsage)
      .optionallyWith(
        subjectInformationAccess.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subjectInformationAccess)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.CsrExtensions.ReadOnly =
    zio.aws.acmpca.model.CsrExtensions.wrap(buildAwsValue())
}
object CsrExtensions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CsrExtensions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CsrExtensions =
      zio.aws.acmpca.model.CsrExtensions(
        keyUsage.map(value => value.asEditable),
        subjectInformationAccess.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyUsage: Option[zio.aws.acmpca.model.KeyUsage.ReadOnly]
    def subjectInformationAccess
        : Option[List[zio.aws.acmpca.model.AccessDescription.ReadOnly]]
    def getKeyUsage
        : ZIO[Any, AwsError, zio.aws.acmpca.model.KeyUsage.ReadOnly] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getSubjectInformationAccess: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.AccessDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "subjectInformationAccess",
      subjectInformationAccess
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CsrExtensions
  ) extends zio.aws.acmpca.model.CsrExtensions.ReadOnly {
    override val keyUsage: Option[zio.aws.acmpca.model.KeyUsage.ReadOnly] =
      scala
        .Option(impl.keyUsage())
        .map(value => zio.aws.acmpca.model.KeyUsage.wrap(value))
    override val subjectInformationAccess
        : Option[List[zio.aws.acmpca.model.AccessDescription.ReadOnly]] = scala
      .Option(impl.subjectInformationAccess())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acmpca.model.AccessDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CsrExtensions
  ): zio.aws.acmpca.model.CsrExtensions.ReadOnly = new Wrapper(impl)
}
