package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.acmpca.model.primitives.{TStamp, S3Key, S3BucketName}
import scala.jdk.CollectionConverters._
final case class DescribeCertificateAuthorityAuditReportResponse(
    auditReportStatus: Option[zio.aws.acmpca.model.AuditReportStatus] = None,
    s3BucketName: Option[S3BucketName] = None,
    s3Key: Option[S3Key] = None,
    createdAt: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse = {
    import DescribeCertificateAuthorityAuditReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
      .builder()
      .optionallyWith(auditReportStatus.map(value => value.unwrap))(
        _.auditReportStatus
      )
      .optionallyWith(
        s3BucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.s3BucketName)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly =
    zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
      .wrap(buildAwsValue())
}
object DescribeCertificateAuthorityAuditReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse =
      zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse(
        auditReportStatus.map(value => value),
        s3BucketName.map(value => value),
        s3Key.map(value => value),
        createdAt.map(value => value)
      )
    def auditReportStatus: Option[zio.aws.acmpca.model.AuditReportStatus]
    def s3BucketName: Option[S3BucketName]
    def s3Key: Option[S3Key]
    def createdAt: Option[TStamp]
    def getAuditReportStatus
        : ZIO[Any, AwsError, zio.aws.acmpca.model.AuditReportStatus] =
      AwsError.unwrapOptionField("auditReportStatus", auditReportStatus)
    def getS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
  ) extends zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly {
    override val auditReportStatus
        : Option[zio.aws.acmpca.model.AuditReportStatus] = scala
      .Option(impl.auditReportStatus())
      .map(value => zio.aws.acmpca.model.AuditReportStatus.wrap(value))
    override val s3BucketName: Option[S3BucketName] = scala
      .Option(impl.s3BucketName())
      .map(value => zio.aws.acmpca.model.primitives.S3BucketName(value))
    override val s3Key: Option[S3Key] = scala
      .Option(impl.s3Key())
      .map(value => zio.aws.acmpca.model.primitives.S3Key(value))
    override val createdAt: Option[TStamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
  ): zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly =
    new Wrapper(impl)
}
