package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeCertificateAuthorityRequest(
    certificateAuthorityArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest = {
    import DescribeCertificateAuthorityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.DescribeCertificateAuthorityRequest.ReadOnly =
    zio.aws.acmpca.model.DescribeCertificateAuthorityRequest
      .wrap(buildAwsValue())
}
object DescribeCertificateAuthorityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.DescribeCertificateAuthorityRequest =
      zio.aws.acmpca.model
        .DescribeCertificateAuthorityRequest(certificateAuthorityArn)
    def certificateAuthorityArn: Arn
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest
  ) extends zio.aws.acmpca.model.DescribeCertificateAuthorityRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest
  ): zio.aws.acmpca.model.DescribeCertificateAuthorityRequest.ReadOnly =
    new Wrapper(impl)
}
