package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCertificateAuthorityResponse(
    certificateAuthority: Option[zio.aws.acmpca.model.CertificateAuthority] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse = {
    import DescribeCertificateAuthorityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse
      .builder()
      .optionallyWith(certificateAuthority.map(value => value.buildAwsValue()))(
        _.certificateAuthority
      )
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.ReadOnly =
    zio.aws.acmpca.model.DescribeCertificateAuthorityResponse
      .wrap(buildAwsValue())
}
object DescribeCertificateAuthorityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.DescribeCertificateAuthorityResponse =
      zio.aws.acmpca.model.DescribeCertificateAuthorityResponse(
        certificateAuthority.map(value => value.asEditable)
      )
    def certificateAuthority
        : Option[zio.aws.acmpca.model.CertificateAuthority.ReadOnly]
    def getCertificateAuthority: ZIO[
      Any,
      AwsError,
      zio.aws.acmpca.model.CertificateAuthority.ReadOnly
    ] = AwsError.unwrapOptionField("certificateAuthority", certificateAuthority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse
  ) extends zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.ReadOnly {
    override val certificateAuthority
        : Option[zio.aws.acmpca.model.CertificateAuthority.ReadOnly] = scala
      .Option(impl.certificateAuthority())
      .map(value => zio.aws.acmpca.model.CertificateAuthority.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse
  ): zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.ReadOnly =
    new Wrapper(impl)
}
