package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.CustomObjectIdentifier
import scala.jdk.CollectionConverters._
final case class ExtendedKeyUsage(
    extendedKeyUsageType: Option[zio.aws.acmpca.model.ExtendedKeyUsageType] =
      None,
    extendedKeyUsageObjectIdentifier: Option[CustomObjectIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsage = {
    import ExtendedKeyUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsage
      .builder()
      .optionallyWith(extendedKeyUsageType.map(value => value.unwrap))(
        _.extendedKeyUsageType
      )
      .optionallyWith(
        extendedKeyUsageObjectIdentifier.map(value =>
          CustomObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.extendedKeyUsageObjectIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly =
    zio.aws.acmpca.model.ExtendedKeyUsage.wrap(buildAwsValue())
}
object ExtendedKeyUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ExtendedKeyUsage =
      zio.aws.acmpca.model.ExtendedKeyUsage(
        extendedKeyUsageType.map(value => value),
        extendedKeyUsageObjectIdentifier.map(value => value)
      )
    def extendedKeyUsageType: Option[zio.aws.acmpca.model.ExtendedKeyUsageType]
    def extendedKeyUsageObjectIdentifier: Option[CustomObjectIdentifier]
    def getExtendedKeyUsageType
        : ZIO[Any, AwsError, zio.aws.acmpca.model.ExtendedKeyUsageType] =
      AwsError.unwrapOptionField("extendedKeyUsageType", extendedKeyUsageType)
    def getExtendedKeyUsageObjectIdentifier
        : ZIO[Any, AwsError, CustomObjectIdentifier] =
      AwsError.unwrapOptionField(
        "extendedKeyUsageObjectIdentifier",
        extendedKeyUsageObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsage
  ) extends zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly {
    override val extendedKeyUsageType
        : Option[zio.aws.acmpca.model.ExtendedKeyUsageType] = scala
      .Option(impl.extendedKeyUsageType())
      .map(value => zio.aws.acmpca.model.ExtendedKeyUsageType.wrap(value))
    override val extendedKeyUsageObjectIdentifier
        : Option[CustomObjectIdentifier] = scala
      .Option(impl.extendedKeyUsageObjectIdentifier())
      .map(value =>
        zio.aws.acmpca.model.primitives.CustomObjectIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsage
  ): zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly = new Wrapper(impl)
}
