package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Extensions(
    certificatePolicies: Option[
      Iterable[zio.aws.acmpca.model.PolicyInformation]
    ] = None,
    extendedKeyUsage: Option[Iterable[zio.aws.acmpca.model.ExtendedKeyUsage]] =
      None,
    keyUsage: Option[zio.aws.acmpca.model.KeyUsage] = None,
    subjectAlternativeNames: Option[
      Iterable[zio.aws.acmpca.model.GeneralName]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.Extensions = {
    import Extensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.Extensions
      .builder()
      .optionallyWith(
        certificatePolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificatePolicies)
      .optionallyWith(
        extendedKeyUsage.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extendedKeyUsage)
      .optionallyWith(keyUsage.map(value => value.buildAwsValue()))(_.keyUsage)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.Extensions.ReadOnly =
    zio.aws.acmpca.model.Extensions.wrap(buildAwsValue())
}
object Extensions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acmpca.model.Extensions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.Extensions =
      zio.aws.acmpca.model.Extensions(
        certificatePolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        extendedKeyUsage.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keyUsage.map(value => value.asEditable),
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificatePolicies
        : Option[List[zio.aws.acmpca.model.PolicyInformation.ReadOnly]]
    def extendedKeyUsage
        : Option[List[zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly]]
    def keyUsage: Option[zio.aws.acmpca.model.KeyUsage.ReadOnly]
    def subjectAlternativeNames
        : Option[List[zio.aws.acmpca.model.GeneralName.ReadOnly]]
    def getCertificatePolicies: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.PolicyInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("certificatePolicies", certificatePolicies)
    def getExtendedKeyUsage: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("extendedKeyUsage", extendedKeyUsage)
    def getKeyUsage
        : ZIO[Any, AwsError, zio.aws.acmpca.model.KeyUsage.ReadOnly] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getSubjectAlternativeNames
        : ZIO[Any, AwsError, List[zio.aws.acmpca.model.GeneralName.ReadOnly]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.Extensions
  ) extends zio.aws.acmpca.model.Extensions.ReadOnly {
    override val certificatePolicies
        : Option[List[zio.aws.acmpca.model.PolicyInformation.ReadOnly]] = scala
      .Option(impl.certificatePolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acmpca.model.PolicyInformation.wrap(item)
        }.toList
      )
    override val extendedKeyUsage
        : Option[List[zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly]] = scala
      .Option(impl.extendedKeyUsage())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acmpca.model.ExtendedKeyUsage.wrap(item)
        }.toList
      )
    override val keyUsage: Option[zio.aws.acmpca.model.KeyUsage.ReadOnly] =
      scala
        .Option(impl.keyUsage())
        .map(value => zio.aws.acmpca.model.KeyUsage.wrap(value))
    override val subjectAlternativeNames
        : Option[List[zio.aws.acmpca.model.GeneralName.ReadOnly]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acmpca.model.GeneralName.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.Extensions
  ): zio.aws.acmpca.model.Extensions.ReadOnly = new Wrapper(impl)
}
