package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.{
  CustomObjectIdentifier,
  String39,
  String253,
  String256
}
import scala.jdk.CollectionConverters._
final case class GeneralName(
    otherName: Option[zio.aws.acmpca.model.OtherName] = None,
    rfc822Name: Option[String256] = None,
    dnsName: Option[String253] = None,
    directoryName: Option[zio.aws.acmpca.model.ASN1Subject] = None,
    ediPartyName: Option[zio.aws.acmpca.model.EdiPartyName] = None,
    uniformResourceIdentifier: Option[String253] = None,
    ipAddress: Option[String39] = None,
    registeredId: Option[CustomObjectIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.GeneralName = {
    import GeneralName.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.GeneralName
      .builder()
      .optionallyWith(otherName.map(value => value.buildAwsValue()))(
        _.otherName
      )
      .optionallyWith(
        rfc822Name.map(value => String256.unwrap(value): java.lang.String)
      )(_.rfc822Name)
      .optionallyWith(
        dnsName.map(value => String253.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(directoryName.map(value => value.buildAwsValue()))(
        _.directoryName
      )
      .optionallyWith(ediPartyName.map(value => value.buildAwsValue()))(
        _.ediPartyName
      )
      .optionallyWith(
        uniformResourceIdentifier.map(value =>
          String253.unwrap(value): java.lang.String
        )
      )(_.uniformResourceIdentifier)
      .optionallyWith(
        ipAddress.map(value => String39.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        registeredId.map(value =>
          CustomObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.registeredId)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.GeneralName.ReadOnly =
    zio.aws.acmpca.model.GeneralName.wrap(buildAwsValue())
}
object GeneralName {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.GeneralName
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.GeneralName =
      zio.aws.acmpca.model.GeneralName(
        otherName.map(value => value.asEditable),
        rfc822Name.map(value => value),
        dnsName.map(value => value),
        directoryName.map(value => value.asEditable),
        ediPartyName.map(value => value.asEditable),
        uniformResourceIdentifier.map(value => value),
        ipAddress.map(value => value),
        registeredId.map(value => value)
      )
    def otherName: Option[zio.aws.acmpca.model.OtherName.ReadOnly]
    def rfc822Name: Option[String256]
    def dnsName: Option[String253]
    def directoryName: Option[zio.aws.acmpca.model.ASN1Subject.ReadOnly]
    def ediPartyName: Option[zio.aws.acmpca.model.EdiPartyName.ReadOnly]
    def uniformResourceIdentifier: Option[String253]
    def ipAddress: Option[String39]
    def registeredId: Option[CustomObjectIdentifier]
    def getOtherName
        : ZIO[Any, AwsError, zio.aws.acmpca.model.OtherName.ReadOnly] =
      AwsError.unwrapOptionField("otherName", otherName)
    def getRfc822Name: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("rfc822Name", rfc822Name)
    def getDnsName: ZIO[Any, AwsError, String253] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getDirectoryName
        : ZIO[Any, AwsError, zio.aws.acmpca.model.ASN1Subject.ReadOnly] =
      AwsError.unwrapOptionField("directoryName", directoryName)
    def getEdiPartyName
        : ZIO[Any, AwsError, zio.aws.acmpca.model.EdiPartyName.ReadOnly] =
      AwsError.unwrapOptionField("ediPartyName", ediPartyName)
    def getUniformResourceIdentifier: ZIO[Any, AwsError, String253] = AwsError
      .unwrapOptionField("uniformResourceIdentifier", uniformResourceIdentifier)
    def getIpAddress: ZIO[Any, AwsError, String39] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getRegisteredId: ZIO[Any, AwsError, CustomObjectIdentifier] =
      AwsError.unwrapOptionField("registeredId", registeredId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.GeneralName
  ) extends zio.aws.acmpca.model.GeneralName.ReadOnly {
    override val otherName: Option[zio.aws.acmpca.model.OtherName.ReadOnly] =
      scala
        .Option(impl.otherName())
        .map(value => zio.aws.acmpca.model.OtherName.wrap(value))
    override val rfc822Name: Option[String256] = scala
      .Option(impl.rfc822Name())
      .map(value => zio.aws.acmpca.model.primitives.String256(value))
    override val dnsName: Option[String253] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.acmpca.model.primitives.String253(value))
    override val directoryName
        : Option[zio.aws.acmpca.model.ASN1Subject.ReadOnly] = scala
      .Option(impl.directoryName())
      .map(value => zio.aws.acmpca.model.ASN1Subject.wrap(value))
    override val ediPartyName
        : Option[zio.aws.acmpca.model.EdiPartyName.ReadOnly] = scala
      .Option(impl.ediPartyName())
      .map(value => zio.aws.acmpca.model.EdiPartyName.wrap(value))
    override val uniformResourceIdentifier: Option[String253] = scala
      .Option(impl.uniformResourceIdentifier())
      .map(value => zio.aws.acmpca.model.primitives.String253(value))
    override val ipAddress: Option[String39] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.acmpca.model.primitives.String39(value))
    override val registeredId: Option[CustomObjectIdentifier] = scala
      .Option(impl.registeredId())
      .map(value =>
        zio.aws.acmpca.model.primitives.CustomObjectIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.GeneralName
  ): zio.aws.acmpca.model.GeneralName.ReadOnly = new Wrapper(impl)
}
