package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.CsrBody
import scala.jdk.CollectionConverters._
final case class GetCertificateAuthorityCsrResponse(
    csr: Option[CsrBody] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse = {
    import GetCertificateAuthorityCsrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse
      .builder()
      .optionallyWith(
        csr.map(value => CsrBody.unwrap(value): java.lang.String)
      )(_.csr)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.ReadOnly =
    zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse
      .wrap(buildAwsValue())
}
object GetCertificateAuthorityCsrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse =
      zio.aws.acmpca.model
        .GetCertificateAuthorityCsrResponse(csr.map(value => value))
    def csr: Option[CsrBody]
    def getCsr: ZIO[Any, AwsError, CsrBody] =
      AwsError.unwrapOptionField("csr", csr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse
  ) extends zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.ReadOnly {
    override val csr: Option[CsrBody] = scala
      .Option(impl.csr())
      .map(value => zio.aws.acmpca.model.primitives.CsrBody(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse
  ): zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.ReadOnly =
    new Wrapper(impl)
}
