package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.AWSPolicy
import scala.jdk.CollectionConverters._
final case class GetPolicyResponse(policy: Option[AWSPolicy] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.GetPolicyResponse = {
    import GetPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.GetPolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => AWSPolicy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.GetPolicyResponse.ReadOnly =
    zio.aws.acmpca.model.GetPolicyResponse.wrap(buildAwsValue())
}
object GetPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.GetPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.GetPolicyResponse =
      zio.aws.acmpca.model.GetPolicyResponse(policy.map(value => value))
    def policy: Option[AWSPolicy]
    def getPolicy: ZIO[Any, AwsError, AWSPolicy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.GetPolicyResponse
  ) extends zio.aws.acmpca.model.GetPolicyResponse.ReadOnly {
    override val policy: Option[AWSPolicy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.acmpca.model.primitives.AWSPolicy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.GetPolicyResponse
  ): zio.aws.acmpca.model.GetPolicyResponse.ReadOnly = new Wrapper(impl)
}
