package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KeyUsage(
    digitalSignature: Option[Boolean] = None,
    nonRepudiation: Option[Boolean] = None,
    keyEncipherment: Option[Boolean] = None,
    dataEncipherment: Option[Boolean] = None,
    keyAgreement: Option[Boolean] = None,
    keyCertSign: Option[Boolean] = None,
    crlSign: Option[Boolean] = None,
    encipherOnly: Option[Boolean] = None,
    decipherOnly: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.acmpca.model.KeyUsage = {
    import KeyUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.KeyUsage
      .builder()
      .optionallyWith(digitalSignature.map(value => value: java.lang.Boolean))(
        _.digitalSignature
      )
      .optionallyWith(nonRepudiation.map(value => value: java.lang.Boolean))(
        _.nonRepudiation
      )
      .optionallyWith(keyEncipherment.map(value => value: java.lang.Boolean))(
        _.keyEncipherment
      )
      .optionallyWith(dataEncipherment.map(value => value: java.lang.Boolean))(
        _.dataEncipherment
      )
      .optionallyWith(keyAgreement.map(value => value: java.lang.Boolean))(
        _.keyAgreement
      )
      .optionallyWith(keyCertSign.map(value => value: java.lang.Boolean))(
        _.keyCertSign
      )
      .optionallyWith(crlSign.map(value => value: java.lang.Boolean))(_.crlSign)
      .optionallyWith(encipherOnly.map(value => value: java.lang.Boolean))(
        _.encipherOnly
      )
      .optionallyWith(decipherOnly.map(value => value: java.lang.Boolean))(
        _.decipherOnly
      )
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.KeyUsage.ReadOnly =
    zio.aws.acmpca.model.KeyUsage.wrap(buildAwsValue())
}
object KeyUsage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acmpca.model.KeyUsage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.KeyUsage =
      zio.aws.acmpca.model.KeyUsage(
        digitalSignature.map(value => value),
        nonRepudiation.map(value => value),
        keyEncipherment.map(value => value),
        dataEncipherment.map(value => value),
        keyAgreement.map(value => value),
        keyCertSign.map(value => value),
        crlSign.map(value => value),
        encipherOnly.map(value => value),
        decipherOnly.map(value => value)
      )
    def digitalSignature: Option[Boolean]
    def nonRepudiation: Option[Boolean]
    def keyEncipherment: Option[Boolean]
    def dataEncipherment: Option[Boolean]
    def keyAgreement: Option[Boolean]
    def keyCertSign: Option[Boolean]
    def crlSign: Option[Boolean]
    def encipherOnly: Option[Boolean]
    def decipherOnly: Option[Boolean]
    def getDigitalSignature: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("digitalSignature", digitalSignature)
    def getNonRepudiation: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("nonRepudiation", nonRepudiation)
    def getKeyEncipherment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("keyEncipherment", keyEncipherment)
    def getDataEncipherment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataEncipherment", dataEncipherment)
    def getKeyAgreement: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("keyAgreement", keyAgreement)
    def getKeyCertSign: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("keyCertSign", keyCertSign)
    def getCrlSign: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crlSign", crlSign)
    def getEncipherOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encipherOnly", encipherOnly)
    def getDecipherOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("decipherOnly", decipherOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.KeyUsage
  ) extends zio.aws.acmpca.model.KeyUsage.ReadOnly {
    override val digitalSignature: Option[Boolean] =
      scala.Option(impl.digitalSignature()).map(value => value: Boolean)
    override val nonRepudiation: Option[Boolean] =
      scala.Option(impl.nonRepudiation()).map(value => value: Boolean)
    override val keyEncipherment: Option[Boolean] =
      scala.Option(impl.keyEncipherment()).map(value => value: Boolean)
    override val dataEncipherment: Option[Boolean] =
      scala.Option(impl.dataEncipherment()).map(value => value: Boolean)
    override val keyAgreement: Option[Boolean] =
      scala.Option(impl.keyAgreement()).map(value => value: Boolean)
    override val keyCertSign: Option[Boolean] =
      scala.Option(impl.keyCertSign()).map(value => value: Boolean)
    override val crlSign: Option[Boolean] =
      scala.Option(impl.crlSign()).map(value => value: Boolean)
    override val encipherOnly: Option[Boolean] =
      scala.Option(impl.encipherOnly()).map(value => value: Boolean)
    override val decipherOnly: Option[Boolean] =
      scala.Option(impl.decipherOnly()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.KeyUsage
  ): zio.aws.acmpca.model.KeyUsage.ReadOnly = new Wrapper(impl)
}
