package zio.aws.acmpca.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class ListCertificateAuthoritiesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    resourceOwner: Option[zio.aws.acmpca.model.ResourceOwner] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest = {
    import ListCertificateAuthoritiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(resourceOwner.map(value => value.unwrap))(_.resourceOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.ListCertificateAuthoritiesRequest.ReadOnly =
    zio.aws.acmpca.model.ListCertificateAuthoritiesRequest.wrap(buildAwsValue())
}
object ListCertificateAuthoritiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ListCertificateAuthoritiesRequest =
      zio.aws.acmpca.model.ListCertificateAuthoritiesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resourceOwner.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def resourceOwner: Option[zio.aws.acmpca.model.ResourceOwner]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceOwner
        : ZIO[Any, AwsError, zio.aws.acmpca.model.ResourceOwner] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest
  ) extends zio.aws.acmpca.model.ListCertificateAuthoritiesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.acmpca.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.acmpca.model.primitives.MaxResults(value))
    override val resourceOwner: Option[zio.aws.acmpca.model.ResourceOwner] =
      scala
        .Option(impl.resourceOwner())
        .map(value => zio.aws.acmpca.model.ResourceOwner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest
  ): zio.aws.acmpca.model.ListCertificateAuthoritiesRequest.ReadOnly =
    new Wrapper(impl)
}
