package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acmpca.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListCertificateAuthoritiesResponse(
    certificateAuthorities: Option[
      Iterable[zio.aws.acmpca.model.CertificateAuthority]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse = {
    import ListCertificateAuthoritiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse
      .builder()
      .optionallyWith(
        certificateAuthorities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificateAuthorities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.ReadOnly =
    zio.aws.acmpca.model.ListCertificateAuthoritiesResponse
      .wrap(buildAwsValue())
}
object ListCertificateAuthoritiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ListCertificateAuthoritiesResponse =
      zio.aws.acmpca.model.ListCertificateAuthoritiesResponse(
        certificateAuthorities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def certificateAuthorities
        : Option[List[zio.aws.acmpca.model.CertificateAuthority.ReadOnly]]
    def nextToken: Option[NextToken]
    def getCertificateAuthorities: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.CertificateAuthority.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "certificateAuthorities",
      certificateAuthorities
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse
  ) extends zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.ReadOnly {
    override val certificateAuthorities
        : Option[List[zio.aws.acmpca.model.CertificateAuthority.ReadOnly]] =
      scala
        .Option(impl.certificateAuthorities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acmpca.model.CertificateAuthority.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.acmpca.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse
  ): zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.ReadOnly =
    new Wrapper(impl)
}
