package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.acmpca.model.primitives.{
  AccountId,
  Arn,
  TStamp,
  AWSPolicy,
  Principal
}
import scala.jdk.CollectionConverters._
final case class Permission(
    certificateAuthorityArn: Option[Arn] = None,
    createdAt: Option[TStamp] = None,
    principal: Option[Principal] = None,
    sourceAccount: Option[AccountId] = None,
    actions: Option[Iterable[zio.aws.acmpca.model.ActionType]] = None,
    policy: Option[AWSPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.Permission = {
    import Permission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.Permission
      .builder()
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        principal.map(value => Principal.unwrap(value): java.lang.String)
      )(_.principal)
      .optionallyWith(
        sourceAccount.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.sourceAccount)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.actionsWithStrings)
      .optionallyWith(
        policy.map(value => AWSPolicy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.Permission.ReadOnly =
    zio.aws.acmpca.model.Permission.wrap(buildAwsValue())
}
object Permission {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acmpca.model.Permission] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.Permission =
      zio.aws.acmpca.model.Permission(
        certificateAuthorityArn.map(value => value),
        createdAt.map(value => value),
        principal.map(value => value),
        sourceAccount.map(value => value),
        actions.map(value => value),
        policy.map(value => value)
      )
    def certificateAuthorityArn: Option[Arn]
    def createdAt: Option[TStamp]
    def principal: Option[Principal]
    def sourceAccount: Option[AccountId]
    def actions: Option[List[zio.aws.acmpca.model.ActionType]]
    def policy: Option[AWSPolicy]
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPrincipal: ZIO[Any, AwsError, Principal] =
      AwsError.unwrapOptionField("principal", principal)
    def getSourceAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("sourceAccount", sourceAccount)
    def getActions: ZIO[Any, AwsError, List[zio.aws.acmpca.model.ActionType]] =
      AwsError.unwrapOptionField("actions", actions)
    def getPolicy: ZIO[Any, AwsError, AWSPolicy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.Permission
  ) extends zio.aws.acmpca.model.Permission.ReadOnly {
    override val certificateAuthorityArn: Option[Arn] = scala
      .Option(impl.certificateAuthorityArn())
      .map(value => zio.aws.acmpca.model.primitives.Arn(value))
    override val createdAt: Option[TStamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val principal: Option[Principal] = scala
      .Option(impl.principal())
      .map(value => zio.aws.acmpca.model.primitives.Principal(value))
    override val sourceAccount: Option[AccountId] = scala
      .Option(impl.sourceAccount())
      .map(value => zio.aws.acmpca.model.primitives.AccountId(value))
    override val actions: Option[List[zio.aws.acmpca.model.ActionType]] = scala
      .Option(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acmpca.model.ActionType.wrap(item)
        }.toList
      )
    override val policy: Option[AWSPolicy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.acmpca.model.primitives.AWSPolicy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.Permission
  ): zio.aws.acmpca.model.Permission.ReadOnly = new Wrapper(impl)
}
