package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.String256
import scala.jdk.CollectionConverters._
final case class Qualifier(cpsUri: String256) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.Qualifier = {
    import Qualifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.Qualifier
      .builder()
      .cpsUri(String256.unwrap(cpsUri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.Qualifier.ReadOnly =
    zio.aws.acmpca.model.Qualifier.wrap(buildAwsValue())
}
object Qualifier {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acmpca.model.Qualifier] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.Qualifier =
      zio.aws.acmpca.model.Qualifier(cpsUri)
    def cpsUri: String256
    def getCpsUri: ZIO[Any, Nothing, String256] = ZIO.succeed(cpsUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.Qualifier
  ) extends zio.aws.acmpca.model.Qualifier.ReadOnly {
    override val cpsUri: String256 =
      zio.aws.acmpca.model.primitives.String256(impl.cpsUri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.Qualifier
  ): zio.aws.acmpca.model.Qualifier.ReadOnly = new Wrapper(impl)
}
