package zio.aws.acmpca
import zio.aws.acmpca.model.IssueCertificateResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.acmpca.model.{
  RestoreCertificateAuthorityRequest,
  GetCertificateAuthorityCsrRequest,
  CreateCertificateAuthorityAuditReportRequest,
  DeleteCertificateAuthorityRequest,
  ListTagsRequest,
  ListCertificateAuthoritiesRequest,
  DeletePermissionRequest,
  TagCertificateAuthorityRequest,
  IssueCertificateRequest,
  UpdateCertificateAuthorityRequest,
  GetPolicyRequest,
  ListPermissionsRequest,
  ImportCertificateAuthorityCertificateRequest,
  RevokeCertificateRequest,
  UntagCertificateAuthorityRequest,
  GetCertificateAuthorityCertificateRequest,
  DeletePolicyRequest,
  DescribeCertificateAuthorityAuditReportRequest,
  CreateCertificateAuthorityRequest,
  DescribeCertificateAuthorityRequest,
  PutPolicyRequest,
  CreatePermissionRequest,
  GetCertificateRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.acmpca.AcmPcaAsyncClient
import zio.stream.ZStream
object AcmPcaMock extends Mock[AcmPca] {
  object GetCertificateAuthorityCertificate
      extends Effect[
        GetCertificateAuthorityCertificateRequest,
        AwsError,
        zio.aws.acmpca.model.GetCertificateAuthorityCertificateResponse.ReadOnly
      ]
  object RevokeCertificate
      extends Effect[RevokeCertificateRequest, AwsError, Unit]
  object ImportCertificateAuthorityCertificate
      extends Effect[
        ImportCertificateAuthorityCertificateRequest,
        AwsError,
        Unit
      ]
  object GetCertificateAuthorityCsr
      extends Effect[
        GetCertificateAuthorityCsrRequest,
        AwsError,
        zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.ReadOnly
      ]
  object IssueCertificate
      extends Effect[IssueCertificateRequest, AwsError, ReadOnly]
  object ListTags
      extends Stream[
        ListTagsRequest,
        AwsError,
        zio.aws.acmpca.model.Tag.ReadOnly
      ]
  object ListTagsPaginated
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.acmpca.model.ListTagsResponse.ReadOnly
      ]
  object DeletePermission
      extends Effect[DeletePermissionRequest, AwsError, Unit]
  object CreateCertificateAuthority
      extends Effect[
        CreateCertificateAuthorityRequest,
        AwsError,
        zio.aws.acmpca.model.CreateCertificateAuthorityResponse.ReadOnly
      ]
  object DescribeCertificateAuthorityAuditReport
      extends Effect[
        DescribeCertificateAuthorityAuditReportRequest,
        AwsError,
        zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly
      ]
  object PutPolicy extends Effect[PutPolicyRequest, AwsError, Unit]
  object RestoreCertificateAuthority
      extends Effect[RestoreCertificateAuthorityRequest, AwsError, Unit]
  object DescribeCertificateAuthority
      extends Effect[
        DescribeCertificateAuthorityRequest,
        AwsError,
        zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.ReadOnly
      ]
  object ListPermissions
      extends Stream[
        ListPermissionsRequest,
        AwsError,
        zio.aws.acmpca.model.Permission.ReadOnly
      ]
  object ListPermissionsPaginated
      extends Effect[
        ListPermissionsRequest,
        AwsError,
        zio.aws.acmpca.model.ListPermissionsResponse.ReadOnly
      ]
  object DeletePolicy extends Effect[DeletePolicyRequest, AwsError, Unit]
  object GetPolicy
      extends Effect[
        GetPolicyRequest,
        AwsError,
        zio.aws.acmpca.model.GetPolicyResponse.ReadOnly
      ]
  object UpdateCertificateAuthority
      extends Effect[UpdateCertificateAuthorityRequest, AwsError, Unit]
  object GetCertificate
      extends Effect[
        GetCertificateRequest,
        AwsError,
        zio.aws.acmpca.model.GetCertificateResponse.ReadOnly
      ]
  object ListCertificateAuthorities
      extends Stream[
        ListCertificateAuthoritiesRequest,
        AwsError,
        zio.aws.acmpca.model.CertificateAuthority.ReadOnly
      ]
  object ListCertificateAuthoritiesPaginated
      extends Effect[
        ListCertificateAuthoritiesRequest,
        AwsError,
        zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.ReadOnly
      ]
  object CreatePermission
      extends Effect[CreatePermissionRequest, AwsError, Unit]
  object CreateCertificateAuthorityAuditReport
      extends Effect[
        CreateCertificateAuthorityAuditReportRequest,
        AwsError,
        zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.ReadOnly
      ]
  object DeleteCertificateAuthority
      extends Effect[DeleteCertificateAuthorityRequest, AwsError, Unit]
  object TagCertificateAuthority
      extends Effect[TagCertificateAuthorityRequest, AwsError, Unit]
  object UntagCertificateAuthority
      extends Effect[UntagCertificateAuthorityRequest, AwsError, Unit]
  val compose: URLayer[Proxy, AcmPca] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new AcmPca {
          val api: AcmPcaAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : AcmPca = this
          def getCertificateAuthorityCertificate(
              request: GetCertificateAuthorityCertificateRequest
          ): IO[
            AwsError,
            zio.aws.acmpca.model.GetCertificateAuthorityCertificateResponse.ReadOnly
          ] = proxy(GetCertificateAuthorityCertificate, request)
          def revokeCertificate(
              request: RevokeCertificateRequest
          ): IO[AwsError, Unit] = proxy(RevokeCertificate, request)
          def importCertificateAuthorityCertificate(
              request: ImportCertificateAuthorityCertificateRequest
          ): IO[AwsError, Unit] =
            proxy(ImportCertificateAuthorityCertificate, request)
          def getCertificateAuthorityCsr(
              request: GetCertificateAuthorityCsrRequest
          ): IO[
            AwsError,
            zio.aws.acmpca.model.GetCertificateAuthorityCsrResponse.ReadOnly
          ] = proxy(GetCertificateAuthorityCsr, request)
          def issueCertificate(
              request: IssueCertificateRequest
          ): IO[AwsError, ReadOnly] = proxy(IssueCertificate, request)
          def listTags(
              request: ListTagsRequest
          ): ZStream[Any, AwsError, zio.aws.acmpca.model.Tag.ReadOnly] =
            rts.unsafeRun(proxy(ListTags, request))
          def listTagsPaginated(
              request: ListTagsRequest
          ): IO[AwsError, zio.aws.acmpca.model.ListTagsResponse.ReadOnly] =
            proxy(ListTagsPaginated, request)
          def deletePermission(
              request: DeletePermissionRequest
          ): IO[AwsError, Unit] = proxy(DeletePermission, request)
          def createCertificateAuthority(
              request: CreateCertificateAuthorityRequest
          ): IO[
            AwsError,
            zio.aws.acmpca.model.CreateCertificateAuthorityResponse.ReadOnly
          ] = proxy(CreateCertificateAuthority, request)
          def describeCertificateAuthorityAuditReport(
              request: DescribeCertificateAuthorityAuditReportRequest
          ): IO[
            AwsError,
            zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportResponse.ReadOnly
          ] = proxy(DescribeCertificateAuthorityAuditReport, request)
          def putPolicy(request: PutPolicyRequest): IO[AwsError, Unit] =
            proxy(PutPolicy, request)
          def restoreCertificateAuthority(
              request: RestoreCertificateAuthorityRequest
          ): IO[AwsError, Unit] = proxy(RestoreCertificateAuthority, request)
          def describeCertificateAuthority(
              request: DescribeCertificateAuthorityRequest
          ): IO[
            AwsError,
            zio.aws.acmpca.model.DescribeCertificateAuthorityResponse.ReadOnly
          ] = proxy(DescribeCertificateAuthority, request)
          def listPermissions(
              request: ListPermissionsRequest
          ): ZStream[Any, AwsError, zio.aws.acmpca.model.Permission.ReadOnly] =
            rts.unsafeRun(proxy(ListPermissions, request))
          def listPermissionsPaginated(request: ListPermissionsRequest): IO[
            AwsError,
            zio.aws.acmpca.model.ListPermissionsResponse.ReadOnly
          ] = proxy(ListPermissionsPaginated, request)
          def deletePolicy(request: DeletePolicyRequest): IO[AwsError, Unit] =
            proxy(DeletePolicy, request)
          def getPolicy(
              request: GetPolicyRequest
          ): IO[AwsError, zio.aws.acmpca.model.GetPolicyResponse.ReadOnly] =
            proxy(GetPolicy, request)
          def updateCertificateAuthority(
              request: UpdateCertificateAuthorityRequest
          ): IO[AwsError, Unit] = proxy(UpdateCertificateAuthority, request)
          def getCertificate(request: GetCertificateRequest): IO[
            AwsError,
            zio.aws.acmpca.model.GetCertificateResponse.ReadOnly
          ] = proxy(GetCertificate, request)
          def listCertificateAuthorities(
              request: ListCertificateAuthoritiesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.acmpca.model.CertificateAuthority.ReadOnly
          ] = rts.unsafeRun(proxy(ListCertificateAuthorities, request))
          def listCertificateAuthoritiesPaginated(
              request: ListCertificateAuthoritiesRequest
          ): IO[
            AwsError,
            zio.aws.acmpca.model.ListCertificateAuthoritiesResponse.ReadOnly
          ] = proxy(ListCertificateAuthoritiesPaginated, request)
          def createPermission(
              request: CreatePermissionRequest
          ): IO[AwsError, Unit] = proxy(CreatePermission, request)
          def createCertificateAuthorityAuditReport(
              request: CreateCertificateAuthorityAuditReportRequest
          ): IO[
            AwsError,
            zio.aws.acmpca.model.CreateCertificateAuthorityAuditReportResponse.ReadOnly
          ] = proxy(CreateCertificateAuthorityAuditReport, request)
          def deleteCertificateAuthority(
              request: DeleteCertificateAuthorityRequest
          ): IO[AwsError, Unit] = proxy(DeleteCertificateAuthority, request)
          def tagCertificateAuthority(
              request: TagCertificateAuthorityRequest
          ): IO[AwsError, Unit] = proxy(TagCertificateAuthority, request)
          def untagCertificateAuthority(
              request: UntagCertificateAuthorityRequest
          ): IO[AwsError, Unit] = proxy(UntagCertificateAuthority, request)
        }
      }
    }
  }
}
