package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait AuditReportStatus {
  def unwrap: software.amazon.awssdk.services.acmpca.model.AuditReportStatus
}
object AuditReportStatus {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.AuditReportStatus
  ): zio.aws.acmpca.model.AuditReportStatus = value match {
    case software.amazon.awssdk.services.acmpca.model.AuditReportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.AuditReportStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.acmpca.model.AuditReportStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.acmpca.model.AuditReportStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acmpca.model.AuditReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AuditReportStatus =
      software.amazon.awssdk.services.acmpca.model.AuditReportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.acmpca.model.AuditReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AuditReportStatus =
      software.amazon.awssdk.services.acmpca.model.AuditReportStatus.CREATING
  }
  case object SUCCESS extends zio.aws.acmpca.model.AuditReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AuditReportStatus =
      software.amazon.awssdk.services.acmpca.model.AuditReportStatus.SUCCESS
  }
  case object FAILED extends zio.aws.acmpca.model.AuditReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.AuditReportStatus =
      software.amazon.awssdk.services.acmpca.model.AuditReportStatus.FAILED
  }
}
