package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.{String1To256, CustomObjectIdentifier}
import scala.jdk.CollectionConverters._
final case class CustomAttribute(
    objectIdentifier: CustomObjectIdentifier,
    value: String1To256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CustomAttribute = {
    import CustomAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CustomAttribute
      .builder()
      .objectIdentifier(
        CustomObjectIdentifier.unwrap(objectIdentifier): java.lang.String
      )
      .value(String1To256.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.CustomAttribute.ReadOnly =
    zio.aws.acmpca.model.CustomAttribute.wrap(buildAwsValue())
}
object CustomAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CustomAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CustomAttribute =
      zio.aws.acmpca.model.CustomAttribute(objectIdentifier, value)
    def objectIdentifier: CustomObjectIdentifier
    def value: String1To256
    def getObjectIdentifier: ZIO[Any, Nothing, CustomObjectIdentifier] =
      ZIO.succeed(objectIdentifier)
    def getValue: ZIO[Any, Nothing, String1To256] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CustomAttribute
  ) extends zio.aws.acmpca.model.CustomAttribute.ReadOnly {
    override val objectIdentifier: CustomObjectIdentifier =
      zio.aws.acmpca.model.primitives
        .CustomObjectIdentifier(impl.objectIdentifier())
    override val value: String1To256 =
      zio.aws.acmpca.model.primitives.String1To256(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CustomAttribute
  ): zio.aws.acmpca.model.CustomAttribute.ReadOnly = new Wrapper(impl)
}
