package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Extensions(
    certificatePolicies: Optional[
      Iterable[zio.aws.acmpca.model.PolicyInformation]
    ] = Optional.Absent,
    extendedKeyUsage: Optional[
      Iterable[zio.aws.acmpca.model.ExtendedKeyUsage]
    ] = Optional.Absent,
    keyUsage: Optional[zio.aws.acmpca.model.KeyUsage] = Optional.Absent,
    subjectAlternativeNames: Optional[
      Iterable[zio.aws.acmpca.model.GeneralName]
    ] = Optional.Absent,
    customExtensions: Optional[Iterable[zio.aws.acmpca.model.CustomExtension]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.Extensions = {
    import Extensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.Extensions
      .builder()
      .optionallyWith(
        certificatePolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificatePolicies)
      .optionallyWith(
        extendedKeyUsage.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extendedKeyUsage)
      .optionallyWith(keyUsage.map(value => value.buildAwsValue()))(_.keyUsage)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        customExtensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customExtensions)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.Extensions.ReadOnly =
    zio.aws.acmpca.model.Extensions.wrap(buildAwsValue())
}
object Extensions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acmpca.model.Extensions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.Extensions =
      zio.aws.acmpca.model.Extensions(
        certificatePolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        extendedKeyUsage.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keyUsage.map(value => value.asEditable),
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customExtensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificatePolicies
        : Optional[List[zio.aws.acmpca.model.PolicyInformation.ReadOnly]]
    def extendedKeyUsage
        : Optional[List[zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly]]
    def keyUsage: Optional[zio.aws.acmpca.model.KeyUsage.ReadOnly]
    def subjectAlternativeNames
        : Optional[List[zio.aws.acmpca.model.GeneralName.ReadOnly]]
    def customExtensions
        : Optional[List[zio.aws.acmpca.model.CustomExtension.ReadOnly]]
    def getCertificatePolicies: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.PolicyInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("certificatePolicies", certificatePolicies)
    def getExtendedKeyUsage: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("extendedKeyUsage", extendedKeyUsage)
    def getKeyUsage
        : ZIO[Any, AwsError, zio.aws.acmpca.model.KeyUsage.ReadOnly] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getSubjectAlternativeNames
        : ZIO[Any, AwsError, List[zio.aws.acmpca.model.GeneralName.ReadOnly]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getCustomExtensions: ZIO[Any, AwsError, List[
      zio.aws.acmpca.model.CustomExtension.ReadOnly
    ]] = AwsError.unwrapOptionField("customExtensions", customExtensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.Extensions
  ) extends zio.aws.acmpca.model.Extensions.ReadOnly {
    override val certificatePolicies
        : Optional[List[zio.aws.acmpca.model.PolicyInformation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acmpca.model.PolicyInformation.wrap(item)
          }.toList
        )
    override val extendedKeyUsage
        : Optional[List[zio.aws.acmpca.model.ExtendedKeyUsage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedKeyUsage())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acmpca.model.ExtendedKeyUsage.wrap(item)
          }.toList
        )
    override val keyUsage: Optional[zio.aws.acmpca.model.KeyUsage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyUsage())
        .map(value => zio.aws.acmpca.model.KeyUsage.wrap(value))
    override val subjectAlternativeNames
        : Optional[List[zio.aws.acmpca.model.GeneralName.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subjectAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acmpca.model.GeneralName.wrap(item)
          }.toList
        )
    override val customExtensions
        : Optional[List[zio.aws.acmpca.model.CustomExtension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customExtensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acmpca.model.CustomExtension.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.Extensions
  ): zio.aws.acmpca.model.Extensions.ReadOnly = new Wrapper(impl)
}
