package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class IssueCertificateResponse(
    certificateArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse = {
    import IssueCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.IssueCertificateResponse.ReadOnly =
    zio.aws.acmpca.model.IssueCertificateResponse.wrap(buildAwsValue())
}
object IssueCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.IssueCertificateResponse =
      zio.aws.acmpca.model
        .IssueCertificateResponse(certificateArn.map(value => value))
    def certificateArn: Optional[Arn]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse
  ) extends zio.aws.acmpca.model.IssueCertificateResponse.ReadOnly {
    override val certificateArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => zio.aws.acmpca.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse
  ): zio.aws.acmpca.model.IssueCertificateResponse.ReadOnly = new Wrapper(impl)
}
