package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait RevocationReason {
  def unwrap: software.amazon.awssdk.services.acmpca.model.RevocationReason
}
object RevocationReason {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.RevocationReason
  ): zio.aws.acmpca.model.RevocationReason = value match {
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.UNSPECIFIED =>
      val r = UNSPECIFIED
      r
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.KEY_COMPROMISE =>
      val r = KEY_COMPROMISE
      r
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.CERTIFICATE_AUTHORITY_COMPROMISE =>
      val r = CERTIFICATE_AUTHORITY_COMPROMISE
      r
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.AFFILIATION_CHANGED =>
      val r = AFFILIATION_CHANGED
      r
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.SUPERSEDED =>
      val r = SUPERSEDED
      r
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.CESSATION_OF_OPERATION =>
      val r = CESSATION_OF_OPERATION
      r
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.PRIVILEGE_WITHDRAWN =>
      val r = PRIVILEGE_WITHDRAWN
      r
    case software.amazon.awssdk.services.acmpca.model.RevocationReason.A_A_COMPROMISE =>
      val r = A_A_COMPROMISE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.UNKNOWN_TO_SDK_VERSION
  }
  case object UNSPECIFIED extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.UNSPECIFIED
  }
  case object KEY_COMPROMISE extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.KEY_COMPROMISE
  }
  case object CERTIFICATE_AUTHORITY_COMPROMISE
      extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.CERTIFICATE_AUTHORITY_COMPROMISE
  }
  case object AFFILIATION_CHANGED
      extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.AFFILIATION_CHANGED
  }
  case object SUPERSEDED extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.SUPERSEDED
  }
  case object CESSATION_OF_OPERATION
      extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.CESSATION_OF_OPERATION
  }
  case object PRIVILEGE_WITHDRAWN
      extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.PRIVILEGE_WITHDRAWN
  }
  case object A_A_COMPROMISE extends zio.aws.acmpca.model.RevocationReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.RevocationReason =
      software.amazon.awssdk.services.acmpca.model.RevocationReason.A_A_COMPROMISE
  }
}
