package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.{AuditReportId, Arn}
import scala.jdk.CollectionConverters._
final case class DescribeCertificateAuthorityAuditReportRequest(
    certificateAuthorityArn: Arn,
    auditReportId: AuditReportId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest = {
    import DescribeCertificateAuthorityAuditReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .auditReportId(AuditReportId.unwrap(auditReportId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest.ReadOnly =
    zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
      .wrap(buildAwsValue())
}
object DescribeCertificateAuthorityAuditReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest =
      zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest(
        certificateAuthorityArn,
        auditReportId
      )
    def certificateAuthorityArn: Arn
    def auditReportId: AuditReportId
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getAuditReportId: ZIO[Any, Nothing, AuditReportId] =
      ZIO.succeed(auditReportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
  ) extends zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val auditReportId: AuditReportId =
      zio.aws.acmpca.model.primitives.AuditReportId(impl.auditReportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
  ): zio.aws.acmpca.model.DescribeCertificateAuthorityAuditReportRequest.ReadOnly =
    new Wrapper(impl)
}
