package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait FailureReason {
  def unwrap: software.amazon.awssdk.services.acmpca.model.FailureReason
}
object FailureReason {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.FailureReason
  ): zio.aws.acmpca.model.FailureReason = value match {
    case software.amazon.awssdk.services.acmpca.model.FailureReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.FailureReason.REQUEST_TIMED_OUT =>
      val r = REQUEST_TIMED_OUT
      r
    case software.amazon.awssdk.services.acmpca.model.FailureReason.UNSUPPORTED_ALGORITHM =>
      val r = UNSUPPORTED_ALGORITHM
      r
    case software.amazon.awssdk.services.acmpca.model.FailureReason.OTHER =>
      val r = OTHER
      r
  }
  case object unknownToSdkVersion extends zio.aws.acmpca.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.FailureReason =
      software.amazon.awssdk.services.acmpca.model.FailureReason.UNKNOWN_TO_SDK_VERSION
  }
  case object REQUEST_TIMED_OUT extends zio.aws.acmpca.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.FailureReason =
      software.amazon.awssdk.services.acmpca.model.FailureReason.REQUEST_TIMED_OUT
  }
  case object UNSUPPORTED_ALGORITHM extends zio.aws.acmpca.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.FailureReason =
      software.amazon.awssdk.services.acmpca.model.FailureReason.UNSUPPORTED_ALGORITHM
  }
  case object OTHER extends zio.aws.acmpca.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.FailureReason =
      software.amazon.awssdk.services.acmpca.model.FailureReason.OTHER
  }
}
