package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.String253
import scala.jdk.CollectionConverters._
final case class OcspConfiguration(
    enabled: Boolean,
    ocspCustomCname: Optional[String253] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.OcspConfiguration = {
    import OcspConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.OcspConfiguration
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        ocspCustomCname.map(value => String253.unwrap(value): java.lang.String)
      )(_.ocspCustomCname)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.OcspConfiguration.ReadOnly =
    zio.aws.acmpca.model.OcspConfiguration.wrap(buildAwsValue())
}
object OcspConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.OcspConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.OcspConfiguration =
      zio.aws.acmpca.model
        .OcspConfiguration(enabled, ocspCustomCname.map(value => value))
    def enabled: Boolean
    def ocspCustomCname: Optional[String253]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getOcspCustomCname: ZIO[Any, AwsError, String253] =
      AwsError.unwrapOptionField("ocspCustomCname", ocspCustomCname)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.OcspConfiguration
  ) extends zio.aws.acmpca.model.OcspConfiguration.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val ocspCustomCname: Optional[String253] = zio.aws.core.internal
      .optionalFromNullable(impl.ocspCustomCname())
      .map(value => zio.aws.acmpca.model.primitives.String253(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.OcspConfiguration
  ): zio.aws.acmpca.model.OcspConfiguration.ReadOnly = new Wrapper(impl)
}
