package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.CustomObjectIdentifier
import scala.jdk.CollectionConverters._
final case class AccessMethod(
    customObjectIdentifier: Optional[CustomObjectIdentifier] = Optional.Absent,
    accessMethodType: Optional[zio.aws.acmpca.model.AccessMethodType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.AccessMethod = {
    import AccessMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.AccessMethod
      .builder()
      .optionallyWith(
        customObjectIdentifier.map(value =>
          CustomObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.customObjectIdentifier)
      .optionallyWith(accessMethodType.map(value => value.unwrap))(
        _.accessMethodType
      )
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.AccessMethod.ReadOnly =
    zio.aws.acmpca.model.AccessMethod.wrap(buildAwsValue())
}
object AccessMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.AccessMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.AccessMethod =
      zio.aws.acmpca.model.AccessMethod(
        customObjectIdentifier.map(value => value),
        accessMethodType.map(value => value)
      )
    def customObjectIdentifier: Optional[CustomObjectIdentifier]
    def accessMethodType: Optional[zio.aws.acmpca.model.AccessMethodType]
    def getCustomObjectIdentifier: ZIO[Any, AwsError, CustomObjectIdentifier] =
      AwsError.unwrapOptionField(
        "customObjectIdentifier",
        customObjectIdentifier
      )
    def getAccessMethodType
        : ZIO[Any, AwsError, zio.aws.acmpca.model.AccessMethodType] =
      AwsError.unwrapOptionField("accessMethodType", accessMethodType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.AccessMethod
  ) extends zio.aws.acmpca.model.AccessMethod.ReadOnly {
    override val customObjectIdentifier: Optional[CustomObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customObjectIdentifier())
        .map(value =>
          zio.aws.acmpca.model.primitives.CustomObjectIdentifier(value)
        )
    override val accessMethodType
        : Optional[zio.aws.acmpca.model.AccessMethodType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessMethodType())
        .map(value => zio.aws.acmpca.model.AccessMethodType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.AccessMethod
  ): zio.aws.acmpca.model.AccessMethod.ReadOnly = new Wrapper(impl)
}
