package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait ExtendedKeyUsageType {
  def unwrap: software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType
}
object ExtendedKeyUsageType {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType
  ): zio.aws.acmpca.model.ExtendedKeyUsageType = value match {
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.SERVER_AUTH =>
      val r = SERVER_AUTH
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.CLIENT_AUTH =>
      val r = CLIENT_AUTH
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.CODE_SIGNING =>
      val r = CODE_SIGNING
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.EMAIL_PROTECTION =>
      val r = EMAIL_PROTECTION
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.TIME_STAMPING =>
      val r = TIME_STAMPING
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.OCSP_SIGNING =>
      val r = OCSP_SIGNING
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.SMART_CARD_LOGIN =>
      val r = SMART_CARD_LOGIN
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.DOCUMENT_SIGNING =>
      val r = DOCUMENT_SIGNING
      r
    case software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.CERTIFICATE_TRANSPARENCY =>
      val r = CERTIFICATE_TRANSPARENCY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVER_AUTH extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.SERVER_AUTH
  }
  case object CLIENT_AUTH extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.CLIENT_AUTH
  }
  case object CODE_SIGNING extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.CODE_SIGNING
  }
  case object EMAIL_PROTECTION
      extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.EMAIL_PROTECTION
  }
  case object TIME_STAMPING extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.TIME_STAMPING
  }
  case object OCSP_SIGNING extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.OCSP_SIGNING
  }
  case object SMART_CARD_LOGIN
      extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.SMART_CARD_LOGIN
  }
  case object DOCUMENT_SIGNING
      extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.DOCUMENT_SIGNING
  }
  case object CERTIFICATE_TRANSPARENCY
      extends zio.aws.acmpca.model.ExtendedKeyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType =
      software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageType.CERTIFICATE_TRANSPARENCY
  }
}
