package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait ActionType {
  def unwrap: software.amazon.awssdk.services.acmpca.model.ActionType
}
object ActionType {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.ActionType
  ): zio.aws.acmpca.model.ActionType = value match {
    case software.amazon.awssdk.services.acmpca.model.ActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.ActionType.ISSUE_CERTIFICATE =>
      val r = IssueCertificate
      r
    case software.amazon.awssdk.services.acmpca.model.ActionType.GET_CERTIFICATE =>
      val r = GetCertificate
      r
    case software.amazon.awssdk.services.acmpca.model.ActionType.LIST_PERMISSIONS =>
      val r = ListPermissions
      r
  }
  case object unknownToSdkVersion extends zio.aws.acmpca.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ActionType =
      software.amazon.awssdk.services.acmpca.model.ActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object IssueCertificate extends zio.aws.acmpca.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ActionType =
      software.amazon.awssdk.services.acmpca.model.ActionType.ISSUE_CERTIFICATE
  }
  case object GetCertificate extends zio.aws.acmpca.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ActionType =
      software.amazon.awssdk.services.acmpca.model.ActionType.GET_CERTIFICATE
  }
  case object ListPermissions extends zio.aws.acmpca.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ActionType =
      software.amazon.awssdk.services.acmpca.model.ActionType.LIST_PERMISSIONS
  }
}
