package zio.aws.acmpca.model
import zio.aws.acmpca.model.primitives.{TStamp, AccountId, Arn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CertificateAuthority(
    arn: Optional[Arn] = Optional.Absent,
    ownerAccount: Optional[AccountId] = Optional.Absent,
    createdAt: Optional[TStamp] = Optional.Absent,
    lastStateChangeAt: Optional[TStamp] = Optional.Absent,
    `type`: Optional[zio.aws.acmpca.model.CertificateAuthorityType] =
      Optional.Absent,
    serial: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.acmpca.model.CertificateAuthorityStatus] =
      Optional.Absent,
    notBefore: Optional[TStamp] = Optional.Absent,
    notAfter: Optional[TStamp] = Optional.Absent,
    failureReason: Optional[zio.aws.acmpca.model.FailureReason] =
      Optional.Absent,
    certificateAuthorityConfiguration: Optional[
      zio.aws.acmpca.model.CertificateAuthorityConfiguration
    ] = Optional.Absent,
    revocationConfiguration: Optional[
      zio.aws.acmpca.model.RevocationConfiguration
    ] = Optional.Absent,
    restorableUntil: Optional[TStamp] = Optional.Absent,
    keyStorageSecurityStandard: Optional[
      zio.aws.acmpca.model.KeyStorageSecurityStandard
    ] = Optional.Absent,
    usageMode: Optional[zio.aws.acmpca.model.CertificateAuthorityUsageMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CertificateAuthority = {
    import CertificateAuthority.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CertificateAuthority
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        ownerAccount.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastStateChangeAt.map(value => TStamp.unwrap(value): Instant)
      )(_.lastStateChangeAt)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(serial.map(value => value: java.lang.String))(_.serial)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(notBefore.map(value => TStamp.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => TStamp.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .optionallyWith(
        certificateAuthorityConfiguration.map(value => value.buildAwsValue())
      )(_.certificateAuthorityConfiguration)
      .optionallyWith(
        revocationConfiguration.map(value => value.buildAwsValue())
      )(_.revocationConfiguration)
      .optionallyWith(
        restorableUntil.map(value => TStamp.unwrap(value): Instant)
      )(_.restorableUntil)
      .optionallyWith(keyStorageSecurityStandard.map(value => value.unwrap))(
        _.keyStorageSecurityStandard
      )
      .optionallyWith(usageMode.map(value => value.unwrap))(_.usageMode)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.CertificateAuthority.ReadOnly =
    zio.aws.acmpca.model.CertificateAuthority.wrap(buildAwsValue())
}
object CertificateAuthority {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CertificateAuthority
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CertificateAuthority =
      zio.aws.acmpca.model.CertificateAuthority(
        arn.map(value => value),
        ownerAccount.map(value => value),
        createdAt.map(value => value),
        lastStateChangeAt.map(value => value),
        `type`.map(value => value),
        serial.map(value => value),
        status.map(value => value),
        notBefore.map(value => value),
        notAfter.map(value => value),
        failureReason.map(value => value),
        certificateAuthorityConfiguration.map(value => value.asEditable),
        revocationConfiguration.map(value => value.asEditable),
        restorableUntil.map(value => value),
        keyStorageSecurityStandard.map(value => value),
        usageMode.map(value => value)
      )
    def arn: Optional[Arn]
    def ownerAccount: Optional[AccountId]
    def createdAt: Optional[TStamp]
    def lastStateChangeAt: Optional[TStamp]
    def `type`: Optional[zio.aws.acmpca.model.CertificateAuthorityType]
    def serial: Optional[String]
    def status: Optional[zio.aws.acmpca.model.CertificateAuthorityStatus]
    def notBefore: Optional[TStamp]
    def notAfter: Optional[TStamp]
    def failureReason: Optional[zio.aws.acmpca.model.FailureReason]
    def certificateAuthorityConfiguration: Optional[
      zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly
    ]
    def revocationConfiguration
        : Optional[zio.aws.acmpca.model.RevocationConfiguration.ReadOnly]
    def restorableUntil: Optional[TStamp]
    def keyStorageSecurityStandard
        : Optional[zio.aws.acmpca.model.KeyStorageSecurityStandard]
    def usageMode: Optional[zio.aws.acmpca.model.CertificateAuthorityUsageMode]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getOwnerAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastStateChangeAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastStateChangeAt", lastStateChangeAt)
    def getType
        : ZIO[Any, AwsError, zio.aws.acmpca.model.CertificateAuthorityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getSerial: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serial", serial)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.acmpca.model.CertificateAuthorityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNotBefore: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getFailureReason
        : ZIO[Any, AwsError, zio.aws.acmpca.model.FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCertificateAuthorityConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateAuthorityConfiguration",
      certificateAuthorityConfiguration
    )
    def getRevocationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.acmpca.model.RevocationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "revocationConfiguration",
      revocationConfiguration
    )
    def getRestorableUntil: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("restorableUntil", restorableUntil)
    def getKeyStorageSecurityStandard
        : ZIO[Any, AwsError, zio.aws.acmpca.model.KeyStorageSecurityStandard] =
      AwsError.unwrapOptionField(
        "keyStorageSecurityStandard",
        keyStorageSecurityStandard
      )
    def getUsageMode: ZIO[
      Any,
      AwsError,
      zio.aws.acmpca.model.CertificateAuthorityUsageMode
    ] = AwsError.unwrapOptionField("usageMode", usageMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CertificateAuthority
  ) extends zio.aws.acmpca.model.CertificateAuthority.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.acmpca.model.primitives.Arn(value))
    override val ownerAccount: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => zio.aws.acmpca.model.primitives.AccountId(value))
    override val createdAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val lastStateChangeAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStateChangeAt())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val `type`
        : Optional[zio.aws.acmpca.model.CertificateAuthorityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.acmpca.model.CertificateAuthorityType.wrap(value))
    override val serial: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serial())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.acmpca.model.CertificateAuthorityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.acmpca.model.CertificateAuthorityStatus.wrap(value)
        )
    override val notBefore: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.notBefore())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val notAfter: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val failureReason: Optional[zio.aws.acmpca.model.FailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value => zio.aws.acmpca.model.FailureReason.wrap(value))
    override val certificateAuthorityConfiguration: Optional[
      zio.aws.acmpca.model.CertificateAuthorityConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateAuthorityConfiguration())
      .map(value =>
        zio.aws.acmpca.model.CertificateAuthorityConfiguration.wrap(value)
      )
    override val revocationConfiguration
        : Optional[zio.aws.acmpca.model.RevocationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revocationConfiguration())
        .map(value => zio.aws.acmpca.model.RevocationConfiguration.wrap(value))
    override val restorableUntil: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.restorableUntil())
      .map(value => zio.aws.acmpca.model.primitives.TStamp(value))
    override val keyStorageSecurityStandard
        : Optional[zio.aws.acmpca.model.KeyStorageSecurityStandard] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyStorageSecurityStandard())
        .map(value =>
          zio.aws.acmpca.model.KeyStorageSecurityStandard.wrap(value)
        )
    override val usageMode
        : Optional[zio.aws.acmpca.model.CertificateAuthorityUsageMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageMode())
        .map(value =>
          zio.aws.acmpca.model.CertificateAuthorityUsageMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CertificateAuthority
  ): zio.aws.acmpca.model.CertificateAuthority.ReadOnly = new Wrapper(impl)
}
