package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class CreateCertificateAuthorityResponse(
    certificateAuthorityArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse = {
    import CreateCertificateAuthorityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse
      .builder()
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.CreateCertificateAuthorityResponse.ReadOnly =
    zio.aws.acmpca.model.CreateCertificateAuthorityResponse
      .wrap(buildAwsValue())
}
object CreateCertificateAuthorityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.CreateCertificateAuthorityResponse =
      zio.aws.acmpca.model.CreateCertificateAuthorityResponse(
        certificateAuthorityArn.map(value => value)
      )
    def certificateAuthorityArn: Optional[Arn]
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse
  ) extends zio.aws.acmpca.model.CreateCertificateAuthorityResponse.ReadOnly {
    override val certificateAuthorityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateAuthorityArn())
      .map(value => zio.aws.acmpca.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse
  ): zio.aws.acmpca.model.CreateCertificateAuthorityResponse.ReadOnly =
    new Wrapper(impl)
}
