package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.{
  CertificateChainBlob,
  CertificateBodyBlob,
  Arn
}
import scala.jdk.CollectionConverters._
final case class ImportCertificateAuthorityCertificateRequest(
    certificateAuthorityArn: Arn,
    certificate: CertificateBodyBlob,
    certificateChain: Optional[CertificateChainBlob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest = {
    import ImportCertificateAuthorityCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .certificate(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(certificate.toArray[Byte])
      )
      .optionallyWith(
        certificateChain.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.certificateChain)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest.ReadOnly =
    zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest
      .wrap(buildAwsValue())
}
object ImportCertificateAuthorityCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest =
      zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest(
        certificateAuthorityArn,
        certificate,
        certificateChain.map(value => value)
      )
    def certificateAuthorityArn: Arn
    def certificate: CertificateBodyBlob
    def certificateChain: Optional[CertificateChainBlob]
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getCertificate: ZIO[Any, Nothing, CertificateBodyBlob] =
      ZIO.succeed(certificate)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChainBlob] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest
  ) extends zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val certificate: CertificateBodyBlob =
      zio.aws.acmpca.model.primitives.CertificateBodyBlob(
        zio.Chunk.fromArray(impl.certificate().asByteArrayUnsafe())
      )
    override val certificateChain: Optional[CertificateChainBlob] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateChain())
        .map(value =>
          zio.aws.acmpca.model.primitives.CertificateChainBlob(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest
  ): zio.aws.acmpca.model.ImportCertificateAuthorityCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
