package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.acmpca.model.primitives.{IdempotencyToken, CsrBlob, Arn}
import scala.jdk.CollectionConverters._
final case class IssueCertificateRequest(
    apiPassthrough: Optional[zio.aws.acmpca.model.ApiPassthrough] =
      Optional.Absent,
    certificateAuthorityArn: Arn,
    csr: CsrBlob,
    signingAlgorithm: zio.aws.acmpca.model.SigningAlgorithm,
    templateArn: Optional[Arn] = Optional.Absent,
    validity: zio.aws.acmpca.model.Validity,
    validityNotBefore: Optional[zio.aws.acmpca.model.Validity] =
      Optional.Absent,
    idempotencyToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest = {
    import IssueCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest
      .builder()
      .optionallyWith(apiPassthrough.map(value => value.buildAwsValue()))(
        _.apiPassthrough
      )
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .csr(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          csr.toArray[Byte]
        )
      )
      .signingAlgorithm(signingAlgorithm.unwrap)
      .optionallyWith(
        templateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .validity(validity.buildAwsValue())
      .optionallyWith(validityNotBefore.map(value => value.buildAwsValue()))(
        _.validityNotBefore
      )
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.IssueCertificateRequest.ReadOnly =
    zio.aws.acmpca.model.IssueCertificateRequest.wrap(buildAwsValue())
}
object IssueCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.IssueCertificateRequest =
      zio.aws.acmpca.model.IssueCertificateRequest(
        apiPassthrough.map(value => value.asEditable),
        certificateAuthorityArn,
        csr,
        signingAlgorithm,
        templateArn.map(value => value),
        validity.asEditable,
        validityNotBefore.map(value => value.asEditable),
        idempotencyToken.map(value => value)
      )
    def apiPassthrough: Optional[zio.aws.acmpca.model.ApiPassthrough.ReadOnly]
    def certificateAuthorityArn: Arn
    def csr: CsrBlob
    def signingAlgorithm: zio.aws.acmpca.model.SigningAlgorithm
    def templateArn: Optional[Arn]
    def validity: zio.aws.acmpca.model.Validity.ReadOnly
    def validityNotBefore: Optional[zio.aws.acmpca.model.Validity.ReadOnly]
    def idempotencyToken: Optional[IdempotencyToken]
    def getApiPassthrough
        : ZIO[Any, AwsError, zio.aws.acmpca.model.ApiPassthrough.ReadOnly] =
      AwsError.unwrapOptionField("apiPassthrough", apiPassthrough)
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
    def getCsr: ZIO[Any, Nothing, CsrBlob] = ZIO.succeed(csr)
    def getSigningAlgorithm
        : ZIO[Any, Nothing, zio.aws.acmpca.model.SigningAlgorithm] =
      ZIO.succeed(signingAlgorithm)
    def getTemplateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getValidity: ZIO[Any, Nothing, zio.aws.acmpca.model.Validity.ReadOnly] =
      ZIO.succeed(validity)
    def getValidityNotBefore
        : ZIO[Any, AwsError, zio.aws.acmpca.model.Validity.ReadOnly] =
      AwsError.unwrapOptionField("validityNotBefore", validityNotBefore)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest
  ) extends zio.aws.acmpca.model.IssueCertificateRequest.ReadOnly {
    override val apiPassthrough
        : Optional[zio.aws.acmpca.model.ApiPassthrough.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiPassthrough())
        .map(value => zio.aws.acmpca.model.ApiPassthrough.wrap(value))
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
    override val csr: CsrBlob = zio.aws.acmpca.model.primitives
      .CsrBlob(zio.Chunk.fromArray(impl.csr().asByteArrayUnsafe()))
    override val signingAlgorithm: zio.aws.acmpca.model.SigningAlgorithm =
      zio.aws.acmpca.model.SigningAlgorithm.wrap(impl.signingAlgorithm())
    override val templateArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.templateArn())
      .map(value => zio.aws.acmpca.model.primitives.Arn(value))
    override val validity: zio.aws.acmpca.model.Validity.ReadOnly =
      zio.aws.acmpca.model.Validity.wrap(impl.validity())
    override val validityNotBefore
        : Optional[zio.aws.acmpca.model.Validity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validityNotBefore())
        .map(value => zio.aws.acmpca.model.Validity.wrap(value))
    override val idempotencyToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idempotencyToken())
        .map(value => zio.aws.acmpca.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest
  ): zio.aws.acmpca.model.IssueCertificateRequest.ReadOnly = new Wrapper(impl)
}
