package zio.aws.acmpca.model
import zio.aws.acmpca.model.primitives.{MaxResults, NextToken}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCertificateAuthoritiesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    resourceOwner: Optional[zio.aws.acmpca.model.ResourceOwner] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest = {
    import ListCertificateAuthoritiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(resourceOwner.map(value => value.unwrap))(_.resourceOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.ListCertificateAuthoritiesRequest.ReadOnly =
    zio.aws.acmpca.model.ListCertificateAuthoritiesRequest.wrap(buildAwsValue())
}
object ListCertificateAuthoritiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.ListCertificateAuthoritiesRequest =
      zio.aws.acmpca.model.ListCertificateAuthoritiesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resourceOwner.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def resourceOwner: Optional[zio.aws.acmpca.model.ResourceOwner]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceOwner
        : ZIO[Any, AwsError, zio.aws.acmpca.model.ResourceOwner] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest
  ) extends zio.aws.acmpca.model.ListCertificateAuthoritiesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.acmpca.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.acmpca.model.primitives.MaxResults(value))
    override val resourceOwner: Optional[zio.aws.acmpca.model.ResourceOwner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceOwner())
        .map(value => zio.aws.acmpca.model.ResourceOwner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest
  ): zio.aws.acmpca.model.ListCertificateAuthoritiesRequest.ReadOnly =
    new Wrapper(impl)
}
