package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PolicyQualifierInfo(
    policyQualifierId: zio.aws.acmpca.model.PolicyQualifierId,
    qualifier: zio.aws.acmpca.model.Qualifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.PolicyQualifierInfo = {
    import PolicyQualifierInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.PolicyQualifierInfo
      .builder()
      .policyQualifierId(policyQualifierId.unwrap)
      .qualifier(qualifier.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.PolicyQualifierInfo.ReadOnly =
    zio.aws.acmpca.model.PolicyQualifierInfo.wrap(buildAwsValue())
}
object PolicyQualifierInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.PolicyQualifierInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.PolicyQualifierInfo =
      zio.aws.acmpca.model
        .PolicyQualifierInfo(policyQualifierId, qualifier.asEditable)
    def policyQualifierId: zio.aws.acmpca.model.PolicyQualifierId
    def qualifier: zio.aws.acmpca.model.Qualifier.ReadOnly
    def getPolicyQualifierId
        : ZIO[Any, Nothing, zio.aws.acmpca.model.PolicyQualifierId] =
      ZIO.succeed(policyQualifierId)
    def getQualifier
        : ZIO[Any, Nothing, zio.aws.acmpca.model.Qualifier.ReadOnly] =
      ZIO.succeed(qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.PolicyQualifierInfo
  ) extends zio.aws.acmpca.model.PolicyQualifierInfo.ReadOnly {
    override val policyQualifierId: zio.aws.acmpca.model.PolicyQualifierId =
      zio.aws.acmpca.model.PolicyQualifierId.wrap(impl.policyQualifierId())
    override val qualifier: zio.aws.acmpca.model.Qualifier.ReadOnly =
      zio.aws.acmpca.model.Qualifier.wrap(impl.qualifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.PolicyQualifierInfo
  ): zio.aws.acmpca.model.PolicyQualifierInfo.ReadOnly = new Wrapper(impl)
}
