package zio.aws.acmpca.model
import scala.jdk.CollectionConverters._
sealed trait ResourceOwner {
  def unwrap: software.amazon.awssdk.services.acmpca.model.ResourceOwner
}
object ResourceOwner {
  def wrap(
      value: software.amazon.awssdk.services.acmpca.model.ResourceOwner
  ): zio.aws.acmpca.model.ResourceOwner = value match {
    case software.amazon.awssdk.services.acmpca.model.ResourceOwner.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acmpca.model.ResourceOwner.SELF =>
      val r = SELF
      r
    case software.amazon.awssdk.services.acmpca.model.ResourceOwner.OTHER_ACCOUNTS =>
      val r = OTHER_ACCOUNTS
      r
  }
  case object unknownToSdkVersion extends zio.aws.acmpca.model.ResourceOwner {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ResourceOwner =
      software.amazon.awssdk.services.acmpca.model.ResourceOwner.UNKNOWN_TO_SDK_VERSION
  }
  case object SELF extends zio.aws.acmpca.model.ResourceOwner {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ResourceOwner =
      software.amazon.awssdk.services.acmpca.model.ResourceOwner.SELF
  }
  case object OTHER_ACCOUNTS extends zio.aws.acmpca.model.ResourceOwner {
    override def unwrap
        : software.amazon.awssdk.services.acmpca.model.ResourceOwner =
      software.amazon.awssdk.services.acmpca.model.ResourceOwner.OTHER_ACCOUNTS
  }
}
