package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acmpca.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class RestoreCertificateAuthorityRequest(
    certificateAuthorityArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest = {
    import RestoreCertificateAuthorityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest
      .builder()
      .certificateAuthorityArn(
        Arn.unwrap(certificateAuthorityArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.acmpca.model.RestoreCertificateAuthorityRequest.ReadOnly =
    zio.aws.acmpca.model.RestoreCertificateAuthorityRequest
      .wrap(buildAwsValue())
}
object RestoreCertificateAuthorityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.RestoreCertificateAuthorityRequest =
      zio.aws.acmpca.model
        .RestoreCertificateAuthorityRequest(certificateAuthorityArn)
    def certificateAuthorityArn: Arn
    def getCertificateAuthorityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest
  ) extends zio.aws.acmpca.model.RestoreCertificateAuthorityRequest.ReadOnly {
    override val certificateAuthorityArn: Arn =
      zio.aws.acmpca.model.primitives.Arn(impl.certificateAuthorityArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest
  ): zio.aws.acmpca.model.RestoreCertificateAuthorityRequest.ReadOnly =
    new Wrapper(impl)
}
