package zio.aws.acmpca.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevocationConfiguration(
    crlConfiguration: Optional[zio.aws.acmpca.model.CrlConfiguration] =
      Optional.Absent,
    ocspConfiguration: Optional[zio.aws.acmpca.model.OcspConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acmpca.model.RevocationConfiguration = {
    import RevocationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acmpca.model.RevocationConfiguration
      .builder()
      .optionallyWith(crlConfiguration.map(value => value.buildAwsValue()))(
        _.crlConfiguration
      )
      .optionallyWith(ocspConfiguration.map(value => value.buildAwsValue()))(
        _.ocspConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.acmpca.model.RevocationConfiguration.ReadOnly =
    zio.aws.acmpca.model.RevocationConfiguration.wrap(buildAwsValue())
}
object RevocationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acmpca.model.RevocationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acmpca.model.RevocationConfiguration =
      zio.aws.acmpca.model.RevocationConfiguration(
        crlConfiguration.map(value => value.asEditable),
        ocspConfiguration.map(value => value.asEditable)
      )
    def crlConfiguration
        : Optional[zio.aws.acmpca.model.CrlConfiguration.ReadOnly]
    def ocspConfiguration
        : Optional[zio.aws.acmpca.model.OcspConfiguration.ReadOnly]
    def getCrlConfiguration
        : ZIO[Any, AwsError, zio.aws.acmpca.model.CrlConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("crlConfiguration", crlConfiguration)
    def getOcspConfiguration
        : ZIO[Any, AwsError, zio.aws.acmpca.model.OcspConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("ocspConfiguration", ocspConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acmpca.model.RevocationConfiguration
  ) extends zio.aws.acmpca.model.RevocationConfiguration.ReadOnly {
    override val crlConfiguration
        : Optional[zio.aws.acmpca.model.CrlConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crlConfiguration())
        .map(value => zio.aws.acmpca.model.CrlConfiguration.wrap(value))
    override val ocspConfiguration
        : Optional[zio.aws.acmpca.model.OcspConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ocspConfiguration())
        .map(value => zio.aws.acmpca.model.OcspConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acmpca.model.RevocationConfiguration
  ): zio.aws.acmpca.model.RevocationConfiguration.ReadOnly = new Wrapper(impl)
}
