package zio.aws.amplify
import zio.aws.amplify.model.ListBranchesResponse.ReadOnly
import software.amazon.awssdk.services.amplify.AmplifyAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.amplify.model.{
  CreateAppRequest,
  DeleteDomainAssociationRequest,
  StartDeploymentRequest,
  UpdateAppRequest,
  ListJobsRequest,
  GetBackendEnvironmentRequest,
  ListBackendEnvironmentsRequest,
  GetJobRequest,
  CreateWebhookRequest,
  CreateBackendEnvironmentRequest,
  GetBranchRequest,
  ListTagsForResourceRequest,
  CreateDomainAssociationRequest,
  GetWebhookRequest,
  CreateBranchRequest,
  DeleteJobRequest,
  ListArtifactsRequest,
  GetDomainAssociationRequest,
  GetAppRequest,
  GetArtifactUrlRequest,
  DeleteWebhookRequest,
  UntagResourceRequest,
  ListBranchesRequest,
  ListWebhooksRequest,
  ListDomainAssociationsRequest,
  ListAppsRequest,
  CreateDeploymentRequest,
  StartJobRequest,
  UpdateBranchRequest,
  DeleteAppRequest,
  UpdateDomainAssociationRequest,
  GenerateAccessLogsRequest,
  DeleteBranchRequest,
  TagResourceRequest,
  DeleteBackendEnvironmentRequest,
  StopJobRequest,
  UpdateWebhookRequest
}
import zio.test.mock.{Proxy, Mock}
object AmplifyMock extends Mock[Amplify] {
  object GetWebhook
      extends Effect[
        GetWebhookRequest,
        AwsError,
        zio.aws.amplify.model.GetWebhookResponse.ReadOnly
      ]
  object GetArtifactUrl
      extends Effect[
        GetArtifactUrlRequest,
        AwsError,
        zio.aws.amplify.model.GetArtifactUrlResponse.ReadOnly
      ]
  object GetApp
      extends Effect[
        GetAppRequest,
        AwsError,
        zio.aws.amplify.model.GetAppResponse.ReadOnly
      ]
  object DeleteBackendEnvironment
      extends Effect[
        DeleteBackendEnvironmentRequest,
        AwsError,
        zio.aws.amplify.model.DeleteBackendEnvironmentResponse.ReadOnly
      ]
  object ListWebhooks
      extends Effect[
        ListWebhooksRequest,
        AwsError,
        zio.aws.amplify.model.ListWebhooksResponse.ReadOnly
      ]
  object StartJob
      extends Effect[
        StartJobRequest,
        AwsError,
        zio.aws.amplify.model.StartJobResponse.ReadOnly
      ]
  object ListApps
      extends Effect[
        ListAppsRequest,
        AwsError,
        zio.aws.amplify.model.ListAppsResponse.ReadOnly
      ]
  object DeleteBranch
      extends Effect[
        DeleteBranchRequest,
        AwsError,
        zio.aws.amplify.model.DeleteBranchResponse.ReadOnly
      ]
  object DeleteWebhook
      extends Effect[
        DeleteWebhookRequest,
        AwsError,
        zio.aws.amplify.model.DeleteWebhookResponse.ReadOnly
      ]
  object StopJob
      extends Effect[
        StopJobRequest,
        AwsError,
        zio.aws.amplify.model.StopJobResponse.ReadOnly
      ]
  object UpdateApp
      extends Effect[
        UpdateAppRequest,
        AwsError,
        zio.aws.amplify.model.UpdateAppResponse.ReadOnly
      ]
  object CreateApp
      extends Effect[
        CreateAppRequest,
        AwsError,
        zio.aws.amplify.model.CreateAppResponse.ReadOnly
      ]
  object UpdateWebhook
      extends Effect[
        UpdateWebhookRequest,
        AwsError,
        zio.aws.amplify.model.UpdateWebhookResponse.ReadOnly
      ]
  object CreateBranch
      extends Effect[
        CreateBranchRequest,
        AwsError,
        zio.aws.amplify.model.CreateBranchResponse.ReadOnly
      ]
  object UpdateDomainAssociation
      extends Effect[
        UpdateDomainAssociationRequest,
        AwsError,
        zio.aws.amplify.model.UpdateDomainAssociationResponse.ReadOnly
      ]
  object DeleteApp
      extends Effect[
        DeleteAppRequest,
        AwsError,
        zio.aws.amplify.model.DeleteAppResponse.ReadOnly
      ]
  object ListArtifacts
      extends Effect[
        ListArtifactsRequest,
        AwsError,
        zio.aws.amplify.model.ListArtifactsResponse.ReadOnly
      ]
  object ListBranches extends Effect[ListBranchesRequest, AwsError, ReadOnly]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.amplify.model.UntagResourceResponse.ReadOnly
      ]
  object CreateDeployment
      extends Effect[
        CreateDeploymentRequest,
        AwsError,
        zio.aws.amplify.model.CreateDeploymentResponse.ReadOnly
      ]
  object GetJob
      extends Effect[
        GetJobRequest,
        AwsError,
        zio.aws.amplify.model.GetJobResponse.ReadOnly
      ]
  object CreateBackendEnvironment
      extends Effect[
        CreateBackendEnvironmentRequest,
        AwsError,
        zio.aws.amplify.model.CreateBackendEnvironmentResponse.ReadOnly
      ]
  object ListBackendEnvironments
      extends Effect[
        ListBackendEnvironmentsRequest,
        AwsError,
        zio.aws.amplify.model.ListBackendEnvironmentsResponse.ReadOnly
      ]
  object CreateDomainAssociation
      extends Effect[
        CreateDomainAssociationRequest,
        AwsError,
        zio.aws.amplify.model.CreateDomainAssociationResponse.ReadOnly
      ]
  object GetBranch
      extends Effect[
        GetBranchRequest,
        AwsError,
        zio.aws.amplify.model.GetBranchResponse.ReadOnly
      ]
  object ListDomainAssociations
      extends Effect[
        ListDomainAssociationsRequest,
        AwsError,
        zio.aws.amplify.model.ListDomainAssociationsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.amplify.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListJobs
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.amplify.model.ListJobsResponse.ReadOnly
      ]
  object CreateWebhook
      extends Effect[
        CreateWebhookRequest,
        AwsError,
        zio.aws.amplify.model.CreateWebhookResponse.ReadOnly
      ]
  object UpdateBranch
      extends Effect[
        UpdateBranchRequest,
        AwsError,
        zio.aws.amplify.model.UpdateBranchResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.amplify.model.TagResourceResponse.ReadOnly
      ]
  object GenerateAccessLogs
      extends Effect[
        GenerateAccessLogsRequest,
        AwsError,
        zio.aws.amplify.model.GenerateAccessLogsResponse.ReadOnly
      ]
  object DeleteDomainAssociation
      extends Effect[
        DeleteDomainAssociationRequest,
        AwsError,
        zio.aws.amplify.model.DeleteDomainAssociationResponse.ReadOnly
      ]
  object GetDomainAssociation
      extends Effect[
        GetDomainAssociationRequest,
        AwsError,
        zio.aws.amplify.model.GetDomainAssociationResponse.ReadOnly
      ]
  object StartDeployment
      extends Effect[
        StartDeploymentRequest,
        AwsError,
        zio.aws.amplify.model.StartDeploymentResponse.ReadOnly
      ]
  object DeleteJob
      extends Effect[
        DeleteJobRequest,
        AwsError,
        zio.aws.amplify.model.DeleteJobResponse.ReadOnly
      ]
  object GetBackendEnvironment
      extends Effect[
        GetBackendEnvironmentRequest,
        AwsError,
        zio.aws.amplify.model.GetBackendEnvironmentResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Amplify] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Amplify {
          val api: AmplifyAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Amplify = this
          def getWebhook(
              request: GetWebhookRequest
          ): IO[AwsError, zio.aws.amplify.model.GetWebhookResponse.ReadOnly] =
            proxy(GetWebhook, request)
          def getArtifactUrl(request: GetArtifactUrlRequest): IO[
            AwsError,
            zio.aws.amplify.model.GetArtifactUrlResponse.ReadOnly
          ] = proxy(GetArtifactUrl, request)
          def getApp(
              request: GetAppRequest
          ): IO[AwsError, zio.aws.amplify.model.GetAppResponse.ReadOnly] =
            proxy(GetApp, request)
          def deleteBackendEnvironment(
              request: DeleteBackendEnvironmentRequest
          ): IO[
            AwsError,
            zio.aws.amplify.model.DeleteBackendEnvironmentResponse.ReadOnly
          ] = proxy(DeleteBackendEnvironment, request)
          def listWebhooks(
              request: ListWebhooksRequest
          ): IO[AwsError, zio.aws.amplify.model.ListWebhooksResponse.ReadOnly] =
            proxy(ListWebhooks, request)
          def startJob(
              request: StartJobRequest
          ): IO[AwsError, zio.aws.amplify.model.StartJobResponse.ReadOnly] =
            proxy(StartJob, request)
          def listApps(
              request: ListAppsRequest
          ): IO[AwsError, zio.aws.amplify.model.ListAppsResponse.ReadOnly] =
            proxy(ListApps, request)
          def deleteBranch(
              request: DeleteBranchRequest
          ): IO[AwsError, zio.aws.amplify.model.DeleteBranchResponse.ReadOnly] =
            proxy(DeleteBranch, request)
          def deleteWebhook(request: DeleteWebhookRequest): IO[
            AwsError,
            zio.aws.amplify.model.DeleteWebhookResponse.ReadOnly
          ] = proxy(DeleteWebhook, request)
          def stopJob(
              request: StopJobRequest
          ): IO[AwsError, zio.aws.amplify.model.StopJobResponse.ReadOnly] =
            proxy(StopJob, request)
          def updateApp(
              request: UpdateAppRequest
          ): IO[AwsError, zio.aws.amplify.model.UpdateAppResponse.ReadOnly] =
            proxy(UpdateApp, request)
          def createApp(
              request: CreateAppRequest
          ): IO[AwsError, zio.aws.amplify.model.CreateAppResponse.ReadOnly] =
            proxy(CreateApp, request)
          def updateWebhook(request: UpdateWebhookRequest): IO[
            AwsError,
            zio.aws.amplify.model.UpdateWebhookResponse.ReadOnly
          ] = proxy(UpdateWebhook, request)
          def createBranch(
              request: CreateBranchRequest
          ): IO[AwsError, zio.aws.amplify.model.CreateBranchResponse.ReadOnly] =
            proxy(CreateBranch, request)
          def updateDomainAssociation(
              request: UpdateDomainAssociationRequest
          ): IO[
            AwsError,
            zio.aws.amplify.model.UpdateDomainAssociationResponse.ReadOnly
          ] = proxy(UpdateDomainAssociation, request)
          def deleteApp(
              request: DeleteAppRequest
          ): IO[AwsError, zio.aws.amplify.model.DeleteAppResponse.ReadOnly] =
            proxy(DeleteApp, request)
          def listArtifacts(request: ListArtifactsRequest): IO[
            AwsError,
            zio.aws.amplify.model.ListArtifactsResponse.ReadOnly
          ] = proxy(ListArtifacts, request)
          def listBranches(
              request: ListBranchesRequest
          ): IO[AwsError, ReadOnly] = proxy(ListBranches, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.amplify.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def createDeployment(request: CreateDeploymentRequest): IO[
            AwsError,
            zio.aws.amplify.model.CreateDeploymentResponse.ReadOnly
          ] = proxy(CreateDeployment, request)
          def getJob(
              request: GetJobRequest
          ): IO[AwsError, zio.aws.amplify.model.GetJobResponse.ReadOnly] =
            proxy(GetJob, request)
          def createBackendEnvironment(
              request: CreateBackendEnvironmentRequest
          ): IO[
            AwsError,
            zio.aws.amplify.model.CreateBackendEnvironmentResponse.ReadOnly
          ] = proxy(CreateBackendEnvironment, request)
          def listBackendEnvironments(
              request: ListBackendEnvironmentsRequest
          ): IO[
            AwsError,
            zio.aws.amplify.model.ListBackendEnvironmentsResponse.ReadOnly
          ] = proxy(ListBackendEnvironments, request)
          def createDomainAssociation(
              request: CreateDomainAssociationRequest
          ): IO[
            AwsError,
            zio.aws.amplify.model.CreateDomainAssociationResponse.ReadOnly
          ] = proxy(CreateDomainAssociation, request)
          def getBranch(
              request: GetBranchRequest
          ): IO[AwsError, zio.aws.amplify.model.GetBranchResponse.ReadOnly] =
            proxy(GetBranch, request)
          def listDomainAssociations(
              request: ListDomainAssociationsRequest
          ): IO[
            AwsError,
            zio.aws.amplify.model.ListDomainAssociationsResponse.ReadOnly
          ] = proxy(ListDomainAssociations, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.amplify.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def listJobs(
              request: ListJobsRequest
          ): IO[AwsError, zio.aws.amplify.model.ListJobsResponse.ReadOnly] =
            proxy(ListJobs, request)
          def createWebhook(request: CreateWebhookRequest): IO[
            AwsError,
            zio.aws.amplify.model.CreateWebhookResponse.ReadOnly
          ] = proxy(CreateWebhook, request)
          def updateBranch(
              request: UpdateBranchRequest
          ): IO[AwsError, zio.aws.amplify.model.UpdateBranchResponse.ReadOnly] =
            proxy(UpdateBranch, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.amplify.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def generateAccessLogs(request: GenerateAccessLogsRequest): IO[
            AwsError,
            zio.aws.amplify.model.GenerateAccessLogsResponse.ReadOnly
          ] = proxy(GenerateAccessLogs, request)
          def deleteDomainAssociation(
              request: DeleteDomainAssociationRequest
          ): IO[
            AwsError,
            zio.aws.amplify.model.DeleteDomainAssociationResponse.ReadOnly
          ] = proxy(DeleteDomainAssociation, request)
          def getDomainAssociation(request: GetDomainAssociationRequest): IO[
            AwsError,
            zio.aws.amplify.model.GetDomainAssociationResponse.ReadOnly
          ] = proxy(GetDomainAssociation, request)
          def startDeployment(request: StartDeploymentRequest): IO[
            AwsError,
            zio.aws.amplify.model.StartDeploymentResponse.ReadOnly
          ] = proxy(StartDeployment, request)
          def deleteJob(
              request: DeleteJobRequest
          ): IO[AwsError, zio.aws.amplify.model.DeleteJobResponse.ReadOnly] =
            proxy(DeleteJob, request)
          def getBackendEnvironment(request: GetBackendEnvironmentRequest): IO[
            AwsError,
            zio.aws.amplify.model.GetBackendEnvironmentResponse.ReadOnly
          ] = proxy(GetBackendEnvironment, request)
        }
      }
    }
    .toLayer
}
