package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  EnableAutoBuild,
  PullRequestEnvironmentName,
  BuildSpec,
  EnablePullRequestPreview,
  BasicAuthCredentials,
  EnablePerformanceMode,
  EnvValue,
  EnvKey,
  Framework
}
import scala.jdk.CollectionConverters.*
final case class AutoBranchCreationConfig(
    stage: Option[zio.aws.amplify.model.Stage] = None,
    framework: Option[Framework] = None,
    enableAutoBuild: Option[EnableAutoBuild] = None,
    environmentVariables: Option[Map[EnvKey, EnvValue]] = None,
    basicAuthCredentials: Option[BasicAuthCredentials] = None,
    enableBasicAuth: Option[EnableBasicAuth] = None,
    enablePerformanceMode: Option[EnablePerformanceMode] = None,
    buildSpec: Option[BuildSpec] = None,
    enablePullRequestPreview: Option[EnablePullRequestPreview] = None,
    pullRequestEnvironmentName: Option[PullRequestEnvironmentName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig = {
    import AutoBranchCreationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig
      .builder()
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .optionallyWith(
        framework.map(value => Framework.unwrap(value): java.lang.String)
      )(_.framework)
      .optionallyWith(
        enableAutoBuild.map(value =>
          EnableAutoBuild.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoBuild)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        enableBasicAuth.map(value =>
          EnableBasicAuth.unwrap(value): java.lang.Boolean
        )
      )(_.enableBasicAuth)
      .optionallyWith(
        enablePerformanceMode.map(value =>
          EnablePerformanceMode.unwrap(value): java.lang.Boolean
        )
      )(_.enablePerformanceMode)
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .optionallyWith(
        enablePullRequestPreview.map(value =>
          EnablePullRequestPreview.unwrap(value): java.lang.Boolean
        )
      )(_.enablePullRequestPreview)
      .optionallyWith(
        pullRequestEnvironmentName.map(value =>
          PullRequestEnvironmentName.unwrap(value): java.lang.String
        )
      )(_.pullRequestEnvironmentName)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly =
    zio.aws.amplify.model.AutoBranchCreationConfig.wrap(buildAwsValue())
}
object AutoBranchCreationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.AutoBranchCreationConfig =
      zio.aws.amplify.model.AutoBranchCreationConfig(
        stage.map(value => value),
        framework.map(value => value),
        enableAutoBuild.map(value => value),
        environmentVariables.map(value => value),
        basicAuthCredentials.map(value => value),
        enableBasicAuth.map(value => value),
        enablePerformanceMode.map(value => value),
        buildSpec.map(value => value),
        enablePullRequestPreview.map(value => value),
        pullRequestEnvironmentName.map(value => value)
      )
    def stage: Option[zio.aws.amplify.model.Stage]
    def framework: Option[Framework]
    def enableAutoBuild: Option[EnableAutoBuild]
    def environmentVariables: Option[Map[EnvKey, EnvValue]]
    def basicAuthCredentials: Option[BasicAuthCredentials]
    def enableBasicAuth: Option[EnableBasicAuth]
    def enablePerformanceMode: Option[EnablePerformanceMode]
    def buildSpec: Option[BuildSpec]
    def enablePullRequestPreview: Option[EnablePullRequestPreview]
    def pullRequestEnvironmentName: Option[PullRequestEnvironmentName]
    def getStage: ZIO[Any, AwsError, zio.aws.amplify.model.Stage] =
      AwsError.unwrapOptionField("stage", stage)
    def getFramework: ZIO[Any, AwsError, Framework] =
      AwsError.unwrapOptionField("framework", framework)
    def getEnableAutoBuild: ZIO[Any, AwsError, EnableAutoBuild] =
      AwsError.unwrapOptionField("enableAutoBuild", enableAutoBuild)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[EnvKey, EnvValue]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getEnableBasicAuth: ZIO[Any, AwsError, EnableBasicAuth] =
      AwsError.unwrapOptionField("enableBasicAuth", enableBasicAuth)
    def getEnablePerformanceMode: ZIO[Any, AwsError, EnablePerformanceMode] =
      AwsError.unwrapOptionField("enablePerformanceMode", enablePerformanceMode)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getEnablePullRequestPreview
        : ZIO[Any, AwsError, EnablePullRequestPreview] = AwsError
      .unwrapOptionField("enablePullRequestPreview", enablePullRequestPreview)
    def getPullRequestEnvironmentName
        : ZIO[Any, AwsError, PullRequestEnvironmentName] =
      AwsError.unwrapOptionField(
        "pullRequestEnvironmentName",
        pullRequestEnvironmentName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig
  ) extends zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly {
    override val stage: Option[zio.aws.amplify.model.Stage] = scala
      .Option(impl.stage())
      .map(value => zio.aws.amplify.model.Stage.wrap(value))
    override val framework: Option[Framework] = scala
      .Option(impl.framework())
      .map(value => zio.aws.amplify.model.primitives.Framework(value))
    override val enableAutoBuild: Option[EnableAutoBuild] = scala
      .Option(impl.enableAutoBuild())
      .map(value => zio.aws.amplify.model.primitives.EnableAutoBuild(value))
    override val environmentVariables: Option[Map[EnvKey, EnvValue]] = scala
      .Option(impl.environmentVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplify.model.primitives
              .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
          })
          .toMap
      )
    override val basicAuthCredentials: Option[BasicAuthCredentials] = scala
      .Option(impl.basicAuthCredentials())
      .map(value =>
        zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
      )
    override val enableBasicAuth: Option[EnableBasicAuth] = scala
      .Option(impl.enableBasicAuth())
      .map(value => zio.aws.amplify.model.primitives.EnableBasicAuth(value))
    override val enablePerformanceMode: Option[EnablePerformanceMode] = scala
      .Option(impl.enablePerformanceMode())
      .map(value =>
        zio.aws.amplify.model.primitives.EnablePerformanceMode(value)
      )
    override val buildSpec: Option[BuildSpec] = scala
      .Option(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val enablePullRequestPreview: Option[EnablePullRequestPreview] =
      scala
        .Option(impl.enablePullRequestPreview())
        .map(value =>
          zio.aws.amplify.model.primitives.EnablePullRequestPreview(value)
        )
    override val pullRequestEnvironmentName
        : Option[PullRequestEnvironmentName] = scala
      .Option(impl.pullRequestEnvironmentName())
      .map(value =>
        zio.aws.amplify.model.primitives.PullRequestEnvironmentName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig
  ): zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly = new Wrapper(impl)
}
