package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  UpdateTime,
  CreateTime,
  StackName,
  EnvironmentName,
  DeploymentArtifacts,
  BackendEnvironmentArn
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BackendEnvironment(
    backendEnvironmentArn: BackendEnvironmentArn,
    environmentName: EnvironmentName,
    stackName: Option[StackName] = None,
    deploymentArtifacts: Option[DeploymentArtifacts] = None,
    createTime: CreateTime,
    updateTime: UpdateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.BackendEnvironment = {
    import BackendEnvironment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.BackendEnvironment
      .builder()
      .backendEnvironmentArn(
        BackendEnvironmentArn.unwrap(backendEnvironmentArn): java.lang.String
      )
      .environmentName(
        EnvironmentName.unwrap(environmentName): java.lang.String
      )
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        deploymentArtifacts.map(value =>
          DeploymentArtifacts.unwrap(value): java.lang.String
        )
      )(_.deploymentArtifacts)
      .createTime(CreateTime.unwrap(createTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.BackendEnvironment.ReadOnly =
    zio.aws.amplify.model.BackendEnvironment.wrap(buildAwsValue())
}
object BackendEnvironment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.BackendEnvironment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.BackendEnvironment =
      zio.aws.amplify.model.BackendEnvironment(
        backendEnvironmentArn,
        environmentName,
        stackName.map(value => value),
        deploymentArtifacts.map(value => value),
        createTime,
        updateTime
      )
    def backendEnvironmentArn: BackendEnvironmentArn
    def environmentName: EnvironmentName
    def stackName: Option[StackName]
    def deploymentArtifacts: Option[DeploymentArtifacts]
    def createTime: CreateTime
    def updateTime: UpdateTime
    def getBackendEnvironmentArn: ZIO[Any, Nothing, BackendEnvironmentArn] =
      ZIO.succeed(backendEnvironmentArn)
    def getEnvironmentName: ZIO[Any, Nothing, EnvironmentName] =
      ZIO.succeed(environmentName)
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getDeploymentArtifacts: ZIO[Any, AwsError, DeploymentArtifacts] =
      AwsError.unwrapOptionField("deploymentArtifacts", deploymentArtifacts)
    def getCreateTime: ZIO[Any, Nothing, CreateTime] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.BackendEnvironment
  ) extends zio.aws.amplify.model.BackendEnvironment.ReadOnly {
    override val backendEnvironmentArn: BackendEnvironmentArn =
      zio.aws.amplify.model.primitives
        .BackendEnvironmentArn(impl.backendEnvironmentArn())
    override val environmentName: EnvironmentName =
      zio.aws.amplify.model.primitives.EnvironmentName(impl.environmentName())
    override val stackName: Option[StackName] = scala
      .Option(impl.stackName())
      .map(value => zio.aws.amplify.model.primitives.StackName(value))
    override val deploymentArtifacts: Option[DeploymentArtifacts] = scala
      .Option(impl.deploymentArtifacts())
      .map(value => zio.aws.amplify.model.primitives.DeploymentArtifacts(value))
    override val createTime: CreateTime =
      zio.aws.amplify.model.primitives.CreateTime(impl.createTime())
    override val updateTime: UpdateTime =
      zio.aws.amplify.model.primitives.UpdateTime(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.BackendEnvironment
  ): zio.aws.amplify.model.BackendEnvironment.ReadOnly = new Wrapper(impl)
}
