package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  CustomHeaders,
  BuildSpec,
  EnableAutoBranchCreation,
  Repository,
  BasicAuthCredentials,
  TagValue,
  EnableBranchAutoBuild,
  ServiceRoleArn,
  Description,
  AutoBranchCreationPattern,
  EnvValue,
  EnvKey,
  EnableBranchAutoDeletion,
  OauthToken,
  Name,
  AccessToken,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateAppRequest(
    name: Name,
    description: Option[Description] = None,
    repository: Option[Repository] = None,
    platform: Option[zio.aws.amplify.model.Platform] = None,
    iamServiceRoleArn: Option[ServiceRoleArn] = None,
    oauthToken: Option[OauthToken] = None,
    accessToken: Option[AccessToken] = None,
    environmentVariables: Option[Map[EnvKey, EnvValue]] = None,
    enableBranchAutoBuild: Option[EnableBranchAutoBuild] = None,
    enableBranchAutoDeletion: Option[EnableBranchAutoDeletion] = None,
    enableBasicAuth: Option[EnableBasicAuth] = None,
    basicAuthCredentials: Option[BasicAuthCredentials] = None,
    customRules: Option[Iterable[zio.aws.amplify.model.CustomRule]] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    buildSpec: Option[BuildSpec] = None,
    customHeaders: Option[CustomHeaders] = None,
    enableAutoBranchCreation: Option[EnableAutoBranchCreation] = None,
    autoBranchCreationPatterns: Option[Iterable[AutoBranchCreationPattern]] =
      None,
    autoBranchCreationConfig: Option[
      zio.aws.amplify.model.AutoBranchCreationConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateAppRequest = {
    import CreateAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateAppRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        repository.map(value => Repository.unwrap(value): java.lang.String)
      )(_.repository)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        iamServiceRoleArn.map(value =>
          ServiceRoleArn.unwrap(value): java.lang.String
        )
      )(_.iamServiceRoleArn)
      .optionallyWith(
        oauthToken.map(value => OauthToken.unwrap(value): java.lang.String)
      )(_.oauthToken)
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .optionallyWith(
        enableBranchAutoBuild.map(value =>
          EnableBranchAutoBuild.unwrap(value): java.lang.Boolean
        )
      )(_.enableBranchAutoBuild)
      .optionallyWith(
        enableBranchAutoDeletion.map(value =>
          EnableBranchAutoDeletion.unwrap(value): java.lang.Boolean
        )
      )(_.enableBranchAutoDeletion)
      .optionallyWith(
        enableBasicAuth.map(value =>
          EnableBasicAuth.unwrap(value): java.lang.Boolean
        )
      )(_.enableBasicAuth)
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        customRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customRules)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .optionallyWith(
        customHeaders.map(value =>
          CustomHeaders.unwrap(value): java.lang.String
        )
      )(_.customHeaders)
      .optionallyWith(
        enableAutoBranchCreation.map(value =>
          EnableAutoBranchCreation.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoBranchCreation)
      .optionallyWith(
        autoBranchCreationPatterns.map(value =>
          value.map { item =>
            AutoBranchCreationPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoBranchCreationPatterns)
      .optionallyWith(
        autoBranchCreationConfig.map(value => value.buildAwsValue())
      )(_.autoBranchCreationConfig)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CreateAppRequest.ReadOnly =
    zio.aws.amplify.model.CreateAppRequest.wrap(buildAwsValue())
}
object CreateAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateAppRequest =
      zio.aws.amplify.model.CreateAppRequest(
        name,
        description.map(value => value),
        repository.map(value => value),
        platform.map(value => value),
        iamServiceRoleArn.map(value => value),
        oauthToken.map(value => value),
        accessToken.map(value => value),
        environmentVariables.map(value => value),
        enableBranchAutoBuild.map(value => value),
        enableBranchAutoDeletion.map(value => value),
        enableBasicAuth.map(value => value),
        basicAuthCredentials.map(value => value),
        customRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        buildSpec.map(value => value),
        customHeaders.map(value => value),
        enableAutoBranchCreation.map(value => value),
        autoBranchCreationPatterns.map(value => value),
        autoBranchCreationConfig.map(value => value.asEditable)
      )
    def name: Name
    def description: Option[Description]
    def repository: Option[Repository]
    def platform: Option[zio.aws.amplify.model.Platform]
    def iamServiceRoleArn: Option[ServiceRoleArn]
    def oauthToken: Option[OauthToken]
    def accessToken: Option[AccessToken]
    def environmentVariables: Option[Map[EnvKey, EnvValue]]
    def enableBranchAutoBuild: Option[EnableBranchAutoBuild]
    def enableBranchAutoDeletion: Option[EnableBranchAutoDeletion]
    def enableBasicAuth: Option[EnableBasicAuth]
    def basicAuthCredentials: Option[BasicAuthCredentials]
    def customRules: Option[List[zio.aws.amplify.model.CustomRule.ReadOnly]]
    def tags: Option[Map[TagKey, TagValue]]
    def buildSpec: Option[BuildSpec]
    def customHeaders: Option[CustomHeaders]
    def enableAutoBranchCreation: Option[EnableAutoBranchCreation]
    def autoBranchCreationPatterns: Option[List[AutoBranchCreationPattern]]
    def autoBranchCreationConfig
        : Option[zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRepository: ZIO[Any, AwsError, Repository] =
      AwsError.unwrapOptionField("repository", repository)
    def getPlatform: ZIO[Any, AwsError, zio.aws.amplify.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getIamServiceRoleArn: ZIO[Any, AwsError, ServiceRoleArn] =
      AwsError.unwrapOptionField("iamServiceRoleArn", iamServiceRoleArn)
    def getOauthToken: ZIO[Any, AwsError, OauthToken] =
      AwsError.unwrapOptionField("oauthToken", oauthToken)
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[EnvKey, EnvValue]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getEnableBranchAutoBuild: ZIO[Any, AwsError, EnableBranchAutoBuild] =
      AwsError.unwrapOptionField("enableBranchAutoBuild", enableBranchAutoBuild)
    def getEnableBranchAutoDeletion
        : ZIO[Any, AwsError, EnableBranchAutoDeletion] = AwsError
      .unwrapOptionField("enableBranchAutoDeletion", enableBranchAutoDeletion)
    def getEnableBasicAuth: ZIO[Any, AwsError, EnableBasicAuth] =
      AwsError.unwrapOptionField("enableBasicAuth", enableBasicAuth)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getCustomRules
        : ZIO[Any, AwsError, List[zio.aws.amplify.model.CustomRule.ReadOnly]] =
      AwsError.unwrapOptionField("customRules", customRules)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getCustomHeaders: ZIO[Any, AwsError, CustomHeaders] =
      AwsError.unwrapOptionField("customHeaders", customHeaders)
    def getEnableAutoBranchCreation
        : ZIO[Any, AwsError, EnableAutoBranchCreation] = AwsError
      .unwrapOptionField("enableAutoBranchCreation", enableAutoBranchCreation)
    def getAutoBranchCreationPatterns
        : ZIO[Any, AwsError, List[AutoBranchCreationPattern]] =
      AwsError.unwrapOptionField(
        "autoBranchCreationPatterns",
        autoBranchCreationPatterns
      )
    def getAutoBranchCreationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoBranchCreationConfig",
      autoBranchCreationConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateAppRequest
  ) extends zio.aws.amplify.model.CreateAppRequest.ReadOnly {
    override val name: Name = zio.aws.amplify.model.primitives.Name(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.amplify.model.primitives.Description(value))
    override val repository: Option[Repository] = scala
      .Option(impl.repository())
      .map(value => zio.aws.amplify.model.primitives.Repository(value))
    override val platform: Option[zio.aws.amplify.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.amplify.model.Platform.wrap(value))
    override val iamServiceRoleArn: Option[ServiceRoleArn] = scala
      .Option(impl.iamServiceRoleArn())
      .map(value => zio.aws.amplify.model.primitives.ServiceRoleArn(value))
    override val oauthToken: Option[OauthToken] = scala
      .Option(impl.oauthToken())
      .map(value => zio.aws.amplify.model.primitives.OauthToken(value))
    override val accessToken: Option[AccessToken] = scala
      .Option(impl.accessToken())
      .map(value => zio.aws.amplify.model.primitives.AccessToken(value))
    override val environmentVariables: Option[Map[EnvKey, EnvValue]] = scala
      .Option(impl.environmentVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplify.model.primitives
              .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
          })
          .toMap
      )
    override val enableBranchAutoBuild: Option[EnableBranchAutoBuild] = scala
      .Option(impl.enableBranchAutoBuild())
      .map(value =>
        zio.aws.amplify.model.primitives.EnableBranchAutoBuild(value)
      )
    override val enableBranchAutoDeletion: Option[EnableBranchAutoDeletion] =
      scala
        .Option(impl.enableBranchAutoDeletion())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableBranchAutoDeletion(value)
        )
    override val enableBasicAuth: Option[EnableBasicAuth] = scala
      .Option(impl.enableBasicAuth())
      .map(value => zio.aws.amplify.model.primitives.EnableBasicAuth(value))
    override val basicAuthCredentials: Option[BasicAuthCredentials] = scala
      .Option(impl.basicAuthCredentials())
      .map(value =>
        zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
      )
    override val customRules
        : Option[List[zio.aws.amplify.model.CustomRule.ReadOnly]] = scala
      .Option(impl.customRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.CustomRule.wrap(item)
        }.toList
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplify.model.primitives
              .TagKey(key) -> zio.aws.amplify.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val buildSpec: Option[BuildSpec] = scala
      .Option(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val customHeaders: Option[CustomHeaders] = scala
      .Option(impl.customHeaders())
      .map(value => zio.aws.amplify.model.primitives.CustomHeaders(value))
    override val enableAutoBranchCreation: Option[EnableAutoBranchCreation] =
      scala
        .Option(impl.enableAutoBranchCreation())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableAutoBranchCreation(value)
        )
    override val autoBranchCreationPatterns
        : Option[List[AutoBranchCreationPattern]] = scala
      .Option(impl.autoBranchCreationPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.primitives.AutoBranchCreationPattern(item)
        }.toList
      )
    override val autoBranchCreationConfig
        : Option[zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly] =
      scala
        .Option(impl.autoBranchCreationConfig())
        .map(value =>
          zio.aws.amplify.model.AutoBranchCreationConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateAppRequest
  ): zio.aws.amplify.model.CreateAppRequest.ReadOnly = new Wrapper(impl)
}
