package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAppResponse(app: zio.aws.amplify.model.App) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateAppResponse = {
    import CreateAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateAppResponse
      .builder()
      .app(app.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CreateAppResponse.ReadOnly =
    zio.aws.amplify.model.CreateAppResponse.wrap(buildAwsValue())
}
object CreateAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateAppResponse =
      zio.aws.amplify.model.CreateAppResponse(app.asEditable)
    def app: zio.aws.amplify.model.App.ReadOnly
    def getApp: ZIO[Any, Nothing, zio.aws.amplify.model.App.ReadOnly] =
      ZIO.succeed(app)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateAppResponse
  ) extends zio.aws.amplify.model.CreateAppResponse.ReadOnly {
    override val app: zio.aws.amplify.model.App.ReadOnly =
      zio.aws.amplify.model.App.wrap(impl.app())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateAppResponse
  ): zio.aws.amplify.model.CreateAppResponse.ReadOnly = new Wrapper(impl)
}
