package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteJobResponse(
    jobSummary: zio.aws.amplify.model.JobSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DeleteJobResponse = {
    import DeleteJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DeleteJobResponse
      .builder()
      .jobSummary(jobSummary.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.DeleteJobResponse.ReadOnly =
    zio.aws.amplify.model.DeleteJobResponse.wrap(buildAwsValue())
}
object DeleteJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DeleteJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DeleteJobResponse =
      zio.aws.amplify.model.DeleteJobResponse(jobSummary.asEditable)
    def jobSummary: zio.aws.amplify.model.JobSummary.ReadOnly
    def getJobSummary
        : ZIO[Any, Nothing, zio.aws.amplify.model.JobSummary.ReadOnly] =
      ZIO.succeed(jobSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DeleteJobResponse
  ) extends zio.aws.amplify.model.DeleteJobResponse.ReadOnly {
    override val jobSummary: zio.aws.amplify.model.JobSummary.ReadOnly =
      zio.aws.amplify.model.JobSummary.wrap(impl.jobSummary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DeleteJobResponse
  ): zio.aws.amplify.model.DeleteJobResponse.ReadOnly = new Wrapper(impl)
}
