package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.LogUrl
import scala.jdk.CollectionConverters.*
final case class GenerateAccessLogsResponse(logUrl: Option[LogUrl] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GenerateAccessLogsResponse = {
    import GenerateAccessLogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GenerateAccessLogsResponse
      .builder()
      .optionallyWith(
        logUrl.map(value => LogUrl.unwrap(value): java.lang.String)
      )(_.logUrl)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GenerateAccessLogsResponse.ReadOnly =
    zio.aws.amplify.model.GenerateAccessLogsResponse.wrap(buildAwsValue())
}
object GenerateAccessLogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GenerateAccessLogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GenerateAccessLogsResponse =
      zio.aws.amplify.model
        .GenerateAccessLogsResponse(logUrl.map(value => value))
    def logUrl: Option[LogUrl]
    def getLogUrl: ZIO[Any, AwsError, LogUrl] =
      AwsError.unwrapOptionField("logUrl", logUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GenerateAccessLogsResponse
  ) extends zio.aws.amplify.model.GenerateAccessLogsResponse.ReadOnly {
    override val logUrl: Option[LogUrl] = scala
      .Option(impl.logUrl())
      .map(value => zio.aws.amplify.model.primitives.LogUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GenerateAccessLogsResponse
  ): zio.aws.amplify.model.GenerateAccessLogsResponse.ReadOnly = new Wrapper(
    impl
  )
}
