package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.ArtifactId
import scala.jdk.CollectionConverters.*
final case class GetArtifactUrlRequest(artifactId: ArtifactId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetArtifactUrlRequest = {
    import GetArtifactUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetArtifactUrlRequest
      .builder()
      .artifactId(ArtifactId.unwrap(artifactId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetArtifactUrlRequest.ReadOnly =
    zio.aws.amplify.model.GetArtifactUrlRequest.wrap(buildAwsValue())
}
object GetArtifactUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetArtifactUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetArtifactUrlRequest =
      zio.aws.amplify.model.GetArtifactUrlRequest(artifactId)
    def artifactId: ArtifactId
    def getArtifactId: ZIO[Any, Nothing, ArtifactId] = ZIO.succeed(artifactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetArtifactUrlRequest
  ) extends zio.aws.amplify.model.GetArtifactUrlRequest.ReadOnly {
    override val artifactId: ArtifactId =
      zio.aws.amplify.model.primitives.ArtifactId(impl.artifactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetArtifactUrlRequest
  ): zio.aws.amplify.model.GetArtifactUrlRequest.ReadOnly = new Wrapper(impl)
}
