package zio.aws.amplify.model
import scala.jdk.CollectionConverters.*
sealed trait JobType {
  def unwrap: software.amazon.awssdk.services.amplify.model.JobType
}
object JobType {
  def wrap(
      value: software.amazon.awssdk.services.amplify.model.JobType
  ): zio.aws.amplify.model.JobType = value match {
    case software.amazon.awssdk.services.amplify.model.JobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplify.model.JobType.RELEASE =>
      val r = RELEASE
      r
    case software.amazon.awssdk.services.amplify.model.JobType.RETRY =>
      val r = RETRY
      r
    case software.amazon.awssdk.services.amplify.model.JobType.MANUAL =>
      val r = MANUAL
      r
    case software.amazon.awssdk.services.amplify.model.JobType.WEB_HOOK =>
      val r = WEB_HOOK
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplify.model.JobType {
    override def unwrap: software.amazon.awssdk.services.amplify.model.JobType =
      software.amazon.awssdk.services.amplify.model.JobType.UNKNOWN_TO_SDK_VERSION
  }
  case object RELEASE extends zio.aws.amplify.model.JobType {
    override def unwrap: software.amazon.awssdk.services.amplify.model.JobType =
      software.amazon.awssdk.services.amplify.model.JobType.RELEASE
  }
  case object RETRY extends zio.aws.amplify.model.JobType {
    override def unwrap: software.amazon.awssdk.services.amplify.model.JobType =
      software.amazon.awssdk.services.amplify.model.JobType.RETRY
  }
  case object MANUAL extends zio.aws.amplify.model.JobType {
    override def unwrap: software.amazon.awssdk.services.amplify.model.JobType =
      software.amazon.awssdk.services.amplify.model.JobType.MANUAL
  }
  case object WEB_HOOK extends zio.aws.amplify.model.JobType {
    override def unwrap: software.amazon.awssdk.services.amplify.model.JobType =
      software.amazon.awssdk.services.amplify.model.JobType.WEB_HOOK
  }
}
