package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListArtifactsResponse(
    artifacts: Iterable[zio.aws.amplify.model.Artifact],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListArtifactsResponse = {
    import ListArtifactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListArtifactsResponse
      .builder()
      .artifacts(artifacts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListArtifactsResponse.ReadOnly =
    zio.aws.amplify.model.ListArtifactsResponse.wrap(buildAwsValue())
}
object ListArtifactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListArtifactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListArtifactsResponse =
      zio.aws.amplify.model.ListArtifactsResponse(
        artifacts.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def artifacts: List[zio.aws.amplify.model.Artifact.ReadOnly]
    def nextToken: Option[NextToken]
    def getArtifacts
        : ZIO[Any, Nothing, List[zio.aws.amplify.model.Artifact.ReadOnly]] =
      ZIO.succeed(artifacts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListArtifactsResponse
  ) extends zio.aws.amplify.model.ListArtifactsResponse.ReadOnly {
    override val artifacts: List[zio.aws.amplify.model.Artifact.ReadOnly] = impl
      .artifacts()
      .asScala
      .map { item =>
        zio.aws.amplify.model.Artifact.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListArtifactsResponse
  ): zio.aws.amplify.model.ListArtifactsResponse.ReadOnly = new Wrapper(impl)
}
