package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListBackendEnvironmentsResponse(
    backendEnvironments: Iterable[zio.aws.amplify.model.BackendEnvironment],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsResponse = {
    import ListBackendEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsResponse
      .builder()
      .backendEnvironments(backendEnvironments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.amplify.model.ListBackendEnvironmentsResponse.ReadOnly =
    zio.aws.amplify.model.ListBackendEnvironmentsResponse.wrap(buildAwsValue())
}
object ListBackendEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListBackendEnvironmentsResponse =
      zio.aws.amplify.model.ListBackendEnvironmentsResponse(
        backendEnvironments.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def backendEnvironments
        : List[zio.aws.amplify.model.BackendEnvironment.ReadOnly]
    def nextToken: Option[NextToken]
    def getBackendEnvironments: ZIO[Any, Nothing, List[
      zio.aws.amplify.model.BackendEnvironment.ReadOnly
    ]] = ZIO.succeed(backendEnvironments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsResponse
  ) extends zio.aws.amplify.model.ListBackendEnvironmentsResponse.ReadOnly {
    override val backendEnvironments
        : List[zio.aws.amplify.model.BackendEnvironment.ReadOnly] = impl
      .backendEnvironments()
      .asScala
      .map { item =>
        zio.aws.amplify.model.BackendEnvironment.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsResponse
  ): zio.aws.amplify.model.ListBackendEnvironmentsResponse.ReadOnly =
    new Wrapper(impl)
}
