package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  BranchName,
  ThumbnailUrl,
  Status,
  LastDeployTime
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ProductionBranch(
    lastDeployTime: Option[LastDeployTime] = None,
    status: Option[Status] = None,
    thumbnailUrl: Option[ThumbnailUrl] = None,
    branchName: Option[BranchName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ProductionBranch = {
    import ProductionBranch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ProductionBranch
      .builder()
      .optionallyWith(
        lastDeployTime.map(value => LastDeployTime.unwrap(value): Instant)
      )(_.lastDeployTime)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        thumbnailUrl.map(value => ThumbnailUrl.unwrap(value): java.lang.String)
      )(_.thumbnailUrl)
      .optionallyWith(
        branchName.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.branchName)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ProductionBranch.ReadOnly =
    zio.aws.amplify.model.ProductionBranch.wrap(buildAwsValue())
}
object ProductionBranch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ProductionBranch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ProductionBranch =
      zio.aws.amplify.model.ProductionBranch(
        lastDeployTime.map(value => value),
        status.map(value => value),
        thumbnailUrl.map(value => value),
        branchName.map(value => value)
      )
    def lastDeployTime: Option[LastDeployTime]
    def status: Option[Status]
    def thumbnailUrl: Option[ThumbnailUrl]
    def branchName: Option[BranchName]
    def getLastDeployTime: ZIO[Any, AwsError, LastDeployTime] =
      AwsError.unwrapOptionField("lastDeployTime", lastDeployTime)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getThumbnailUrl: ZIO[Any, AwsError, ThumbnailUrl] =
      AwsError.unwrapOptionField("thumbnailUrl", thumbnailUrl)
    def getBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("branchName", branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ProductionBranch
  ) extends zio.aws.amplify.model.ProductionBranch.ReadOnly {
    override val lastDeployTime: Option[LastDeployTime] = scala
      .Option(impl.lastDeployTime())
      .map(value => zio.aws.amplify.model.primitives.LastDeployTime(value))
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.amplify.model.primitives.Status(value))
    override val thumbnailUrl: Option[ThumbnailUrl] = scala
      .Option(impl.thumbnailUrl())
      .map(value => zio.aws.amplify.model.primitives.ThumbnailUrl(value))
    override val branchName: Option[BranchName] = scala
      .Option(impl.branchName())
      .map(value => zio.aws.amplify.model.primitives.BranchName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ProductionBranch
  ): zio.aws.amplify.model.ProductionBranch.ReadOnly = new Wrapper(impl)
}
