package zio.aws.amplify.model
import scala.jdk.CollectionConverters.*
sealed trait Stage {
  def unwrap: software.amazon.awssdk.services.amplify.model.Stage
}
object Stage {
  def wrap(
      value: software.amazon.awssdk.services.amplify.model.Stage
  ): zio.aws.amplify.model.Stage = value match {
    case software.amazon.awssdk.services.amplify.model.Stage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplify.model.Stage.PRODUCTION =>
      val r = PRODUCTION
      r
    case software.amazon.awssdk.services.amplify.model.Stage.BETA =>
      val r = BETA
      r
    case software.amazon.awssdk.services.amplify.model.Stage.DEVELOPMENT =>
      val r = DEVELOPMENT
      r
    case software.amazon.awssdk.services.amplify.model.Stage.EXPERIMENTAL =>
      val r = EXPERIMENTAL
      r
    case software.amazon.awssdk.services.amplify.model.Stage.PULL_REQUEST =>
      val r = PULL_REQUEST
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplify.model.Stage {
    override def unwrap: software.amazon.awssdk.services.amplify.model.Stage =
      software.amazon.awssdk.services.amplify.model.Stage.UNKNOWN_TO_SDK_VERSION
  }
  case object PRODUCTION extends zio.aws.amplify.model.Stage {
    override def unwrap: software.amazon.awssdk.services.amplify.model.Stage =
      software.amazon.awssdk.services.amplify.model.Stage.PRODUCTION
  }
  case object BETA extends zio.aws.amplify.model.Stage {
    override def unwrap: software.amazon.awssdk.services.amplify.model.Stage =
      software.amazon.awssdk.services.amplify.model.Stage.BETA
  }
  case object DEVELOPMENT extends zio.aws.amplify.model.Stage {
    override def unwrap: software.amazon.awssdk.services.amplify.model.Stage =
      software.amazon.awssdk.services.amplify.model.Stage.DEVELOPMENT
  }
  case object EXPERIMENTAL extends zio.aws.amplify.model.Stage {
    override def unwrap: software.amazon.awssdk.services.amplify.model.Stage =
      software.amazon.awssdk.services.amplify.model.Stage.EXPERIMENTAL
  }
  case object PULL_REQUEST extends zio.aws.amplify.model.Stage {
    override def unwrap: software.amazon.awssdk.services.amplify.model.Stage =
      software.amazon.awssdk.services.amplify.model.Stage.PULL_REQUEST
  }
}
