package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{SourceUrl, JobId, BranchName, AppId}
import scala.jdk.CollectionConverters.*
final case class StartDeploymentRequest(
    appId: AppId,
    branchName: BranchName,
    jobId: Option[JobId] = None,
    sourceUrl: Option[SourceUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.StartDeploymentRequest = {
    import StartDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.StartDeploymentRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        sourceUrl.map(value => SourceUrl.unwrap(value): java.lang.String)
      )(_.sourceUrl)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.StartDeploymentRequest.ReadOnly =
    zio.aws.amplify.model.StartDeploymentRequest.wrap(buildAwsValue())
}
object StartDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.StartDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.StartDeploymentRequest =
      zio.aws.amplify.model.StartDeploymentRequest(
        appId,
        branchName,
        jobId.map(value => value),
        sourceUrl.map(value => value)
      )
    def appId: AppId
    def branchName: BranchName
    def jobId: Option[JobId]
    def sourceUrl: Option[SourceUrl]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getSourceUrl: ZIO[Any, AwsError, SourceUrl] =
      AwsError.unwrapOptionField("sourceUrl", sourceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.StartDeploymentRequest
  ) extends zio.aws.amplify.model.StartDeploymentRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.amplify.model.primitives.JobId(value))
    override val sourceUrl: Option[SourceUrl] = scala
      .Option(impl.sourceUrl())
      .map(value => zio.aws.amplify.model.primitives.SourceUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.StartDeploymentRequest
  ): zio.aws.amplify.model.StartDeploymentRequest.ReadOnly = new Wrapper(impl)
}
